/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.slots;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SimpleSlot
extends Slot {
    public boolean active = true;
    public boolean locked = false;
    private Runnable onChange = () -> {};

    public SimpleSlot(Container container, int index, int x, int y) {
        super(container, index, x, y);
    }

    public boolean m_6659_() {
        return this.active;
    }

    public boolean m_5857_(@NotNull ItemStack stack) {
        if (this.locked) {
            return false;
        }
        return super.m_5857_(stack);
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        if (this.locked) {
            return ItemStack.f_41583_;
        }
        return super.m_6201_(amount);
    }

    public boolean m_8010_(@NotNull Player player) {
        if (this.locked) {
            return false;
        }
        return super.m_8010_(player);
    }

    public final void setListener(@Nonnull Runnable onChange) {
        this.onChange = onChange;
    }

    public void m_6654_() {
        super.m_6654_();
        this.onChange.run();
    }

    public static void SetActive(AbstractContainerMenu menu) {
        SimpleSlot.SetActive(menu, slot -> true);
    }

    public static void SetActive(AbstractContainerMenu menu, Function<SimpleSlot, Boolean> filter) {
        menu.f_38839_.forEach(slot -> {
            SimpleSlot simpleSlot;
            if (slot instanceof SimpleSlot && ((Boolean)filter.apply(simpleSlot = (SimpleSlot)((Object)slot))).booleanValue()) {
                simpleSlot.active = true;
            }
        });
    }

    public static void SetInactive(AbstractContainerMenu menu) {
        SimpleSlot.SetInactive(menu, slot -> true);
    }

    public static void SetInactive(AbstractContainerMenu menu, Function<SimpleSlot, Boolean> filter) {
        menu.f_38839_.forEach(slot -> {
            SimpleSlot simpleSlot;
            if (slot instanceof SimpleSlot && ((Boolean)filter.apply(simpleSlot = (SimpleSlot)((Object)slot))).booleanValue()) {
                simpleSlot.active = false;
            }
        });
    }

    public static void SetActive(List<? extends SimpleSlot> slots) {
        SimpleSlot.SetActive(slots, true);
    }

    public static void SetInactive(List<? extends SimpleSlot> slots) {
        SimpleSlot.SetActive(slots, false);
    }

    public static void SetActive(List<? extends SimpleSlot> slots, boolean active) {
        for (SimpleSlot simpleSlot : slots) {
            simpleSlot.active = active;
        }
    }

    public static void SetLocked(AbstractContainerMenu menu, boolean locked) {
        SimpleSlot.SetLocked(menu, locked, slot -> true);
    }

    public static void SetLocked(AbstractContainerMenu menu, boolean locked, Function<SimpleSlot, Boolean> filter) {
        menu.f_38839_.forEach(slot -> {
            SimpleSlot simpleSlot;
            if (slot instanceof SimpleSlot && ((Boolean)filter.apply(simpleSlot = (SimpleSlot)((Object)slot))).booleanValue()) {
                simpleSlot.locked = locked;
            }
        });
    }

    public static void Lock(AbstractContainerMenu menu) {
        SimpleSlot.SetLocked(menu, true);
    }

    public static void Lock(AbstractContainerMenu menu, Function<SimpleSlot, Boolean> filter) {
        SimpleSlot.SetLocked(menu, true, filter);
    }

    public static void Unlock(AbstractContainerMenu menu) {
        SimpleSlot.SetLocked(menu, false);
    }

    public static void Unlock(AbstractContainerMenu menu, Function<SimpleSlot, Boolean> filter) {
        SimpleSlot.SetLocked(menu, false, filter);
    }
}

