/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.menus.containers.SuppliedContainer;
import io.github.lightman314.lightmanscurrency.common.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.emergencyejection.SPacketChangeSelectedData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TraderRecoveryMenu
extends EasyMenu {
    public static final MenuProvider PROVIDER = new Provider();
    private int selectedIndex = 0;
    private final Container dummyContainer = new SimpleContainer(54);

    public TraderRecoveryMenu(int menuID, Inventory inventory) {
        this((MenuType)ModMenus.TRADER_RECOVERY.get(), menuID, inventory);
    }

    @Override
    public boolean isClient() {
        return this.player.m_9236_().f_46443_;
    }

    public List<EjectionData> getValidEjectionData() {
        return EjectionSaveData.GetValidEjectionData(this.isClient(), this.player);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public EjectionData getSelectedData() {
        List<EjectionData> data = this.getValidEjectionData();
        if (data.size() > 0 && this.selectedIndex >= 0 && this.selectedIndex < data.size()) {
            return data.get(this.selectedIndex);
        }
        return null;
    }

    private Container getSelectedContainer() {
        List<EjectionData> data = this.getValidEjectionData();
        this.changeSelection(this.selectedIndex, data.size());
        if (data.size() > 0 && this.selectedIndex >= 0 && this.selectedIndex < data.size()) {
            return data.get(this.selectedIndex);
        }
        return this.dummyContainer;
    }

    protected TraderRecoveryMenu(MenuType<?> type, int menuID, Inventory inventory) {
        super(type, menuID, inventory);
        int x;
        int y;
        SuppliedContainer ejectionContainer = new SuppliedContainer(this::getSelectedContainer);
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new OutputSlot(ejectionContainer, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 140 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)inventory, x2, 8 + x2 * 18, 198));
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex < 54 ? !this.m_38903_(itemstack1, 54, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 54, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.dummyContainer);
    }

    public void changeSelection(int newSelection) {
        this.changeSelection(newSelection, this.getValidEjectionData().size());
    }

    private void changeSelection(int newSelection, int dataSize) {
        int oldSelection = this.selectedIndex;
        this.selectedIndex = MathUtil.clamp(newSelection, 0, dataSize - 1);
        if (this.selectedIndex != oldSelection && !this.isClient()) {
            LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(this.player), (Object)new SPacketChangeSelectedData(this.selectedIndex));
        }
    }

    private static class Provider
    implements MenuProvider {
        private Provider() {
        }

        public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new TraderRecoveryMenu(id, inventory);
        }

        @Nonnull
        public Component m_5446_() {
            return Component.m_237119_();
        }
    }
}

