/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.InteractionSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;

public class TraderMenu
extends EasyMenu
implements IValidatedMenu {
    public final Supplier<ITraderSource> traderSource;
    public static final int SLOT_OFFSET = 15;
    InteractionSlot interactionSlot;
    Container coins = new SimpleContainer(5);
    List<Slot> coinSlots = new ArrayList<Slot>();
    private final MenuValidator validator;

    public InteractionSlot getInteractionSlot() {
        return this.interactionSlot;
    }

    public Container getCoinInventory() {
        return this.coins;
    }

    public List<Slot> getCoinSlots() {
        return this.coinSlots;
    }

    @Override
    @Nonnull
    public MenuValidator getValidator() {
        return this.validator;
    }

    public TraderMenu(int windowID, Inventory inventory, long traderID, MenuValidator validator) {
        this((MenuType)ModMenus.TRADER.get(), windowID, inventory, () -> TraderSaveData.GetTrader(inventory.f_35978_.m_9236_().f_46443_, traderID), validator);
    }

    protected TraderMenu(MenuType<?> type, int windowID, Inventory inventory, Supplier<ITraderSource> traderSource, MenuValidator validator) {
        super(type, windowID, inventory);
        this.validator = validator;
        this.traderSource = traderSource;
        this.addValidator((NonNullSupplier<Boolean>)((NonNullSupplier)this::traderSourceValid));
        this.addValidator(this.validator);
        this.init(inventory);
        for (TraderData trader : this.traderSource.get().getTraders()) {
            if (trader == null) continue;
            trader.userOpen(this.player);
        }
    }

    public TradeContext getContext(TraderData trader) {
        return TradeContext.create(trader, this.player).withCoinSlots(this.coins).withInteractionSlot(this.interactionSlot).build();
    }

    protected void init(Inventory inventory) {
        int x;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 23 + x2 * 18, 154 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 23 + x * 18, 212));
        }
        for (x = 0; x < this.coins.m_6643_(); ++x) {
            this.coinSlots.add(this.m_38897_(new CoinSlot(this.coins, x, 23 + (x + 4) * 18, 122)));
        }
        ArrayList<InteractionSlotData> slotData = new ArrayList<InteractionSlotData>();
        for (TraderData trader : this.traderSource.get().getTraders()) {
            trader.addInteractionSlots(slotData);
        }
        this.interactionSlot = new InteractionSlot(slotData, 23, 122);
        this.m_38897_(this.interactionSlot);
    }

    private boolean traderSourceValid() {
        return this.traderSource != null && this.traderSource.get() != null && this.traderSource.get().getTraders() != null && this.traderSource.get().getTraders().size() > 0;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.coins);
        this.m_150411_(player, this.interactionSlot.f_40218_);
        if (this.traderSource.get() != null) {
            for (TraderData trader : this.traderSource.get().getTraders()) {
                if (trader == null) continue;
                trader.userClose(this.player);
            }
        }
    }

    public void ExecuteTrade(int traderIndex, int tradeIndex) {
        ITraderSource traderSource = this.traderSource.get();
        if (traderSource == null) {
            this.player.m_6915_();
            return;
        }
        List<TraderData> traderList = traderSource.getTraders();
        if (traderIndex >= 0 && traderIndex < traderList.size()) {
            TraderData trader = traderSource.getTraders().get(traderIndex);
            if (trader == null) {
                LightmansCurrency.LogWarning("Trader at index " + traderIndex + " is null.");
                return;
            }
            TradeContext.TradeResult result = trader.TryExecuteTrade(this.getContext(trader), tradeIndex);
            if (result.hasMessage()) {
                LightmansCurrency.LogInfo(result.failMessage.getString());
            }
        } else {
            LightmansCurrency.LogWarning("Trader " + traderIndex + " is not a valid trader index.");
        }
    }

    public boolean isSingleTrader() {
        ITraderSource tradeSource = this.traderSource.get();
        if (tradeSource == null) {
            this.player.m_6915_();
            return false;
        }
        return tradeSource.isSingleTrader() && tradeSource.getTraders().size() == 1;
    }

    public TraderData getSingleTrader() {
        if (this.isSingleTrader()) {
            return this.traderSource.get().getSingleTrader();
        }
        return null;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 36 ? !this.m_38903_(slotStack, 36, this.f_38839_.size(), false) : index < this.f_38839_.size() && !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void CollectCoinStorage() {
        if (this.isSingleTrader()) {
            LightmansCurrency.LogInfo("Attempting to collect coins from trader.");
            TraderData trader = this.getSingleTrader();
            if (trader.hasPermission(this.player, "collectCoins")) {
                CoinValue payment = trader.getInternalStoredMoney();
                if (this.getContext(trader).givePayment(payment)) {
                    trader.clearStoredMoney();
                }
            } else {
                Permissions.PermissionWarning(this.player, "collect stored coins", "collectCoins");
            }
        }
    }

    public static class TraderMenuAllNetwork
    extends TraderMenu {
        public TraderMenuAllNetwork(int windowID, Inventory inventory, MenuValidator validator) {
            super((MenuType)ModMenus.TRADER_NETWORK_ALL.get(), windowID, inventory, ITraderSource.UniversalTraderSource(inventory.f_35978_.m_9236_().f_46443_), validator);
        }
    }

    public static class TraderMenuBlockSource
    extends TraderMenu {
        public TraderMenuBlockSource(int windowID, Inventory inventory, BlockPos pos, MenuValidator validator) {
            super((MenuType)ModMenus.TRADER_BLOCK.get(), windowID, inventory, () -> {
                BlockEntity patt7886$temp = inventory.f_35978_.m_9236_().m_7702_(pos);
                if (patt7886$temp instanceof ITraderSource) {
                    ITraderSource source = (ITraderSource)patt7886$temp;
                    return source;
                }
                return null;
            }, validator);
        }
    }
}

