/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.glm;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CoinsInChestsModifier
implements IGlobalLootModifier {
    private CoinsInChestsModifier() {
        LightmansCurrency.LogInfo("CoinsInChestModifier was deserialized!");
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)Config.COMMON.enableChestLoot.get()).booleanValue()) {
            return generatedLoot;
        }
        String lootTable = context.getQueriedLootTableId().toString();
        LootManager.ChestPoolLevel lootLevel = LootManager.GetChestPoolLevel(lootTable);
        if (lootLevel != null) {
            LightmansCurrency.LogDebug("Loot table '" + lootTable + "' has " + lootLevel + " level chest loot. Adding coins to the spawned loot.");
            List<ItemStack> coinLoot = LootManager.GetRandomChestLoot(lootLevel, context);
            for (ItemStack coin : coinLoot) {
                LightmansCurrency.LogDebug("Adding " + coin.m_41613_() + "x " + ForgeRegistries.ITEMS.getKey((Object)coin.m_41720_()).toString() + " to the chest loot.");
                generatedLoot.add((Object)coin);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return new Serializer();
    }

    public static class Serializer
    implements Codec<CoinsInChestsModifier> {
        public <T> DataResult<T> encode(CoinsInChestsModifier input, DynamicOps<T> ops, T prefix) {
            return DataResult.success(prefix);
        }

        public <T> DataResult<Pair<CoinsInChestsModifier, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of((Object)new CoinsInChestsModifier(), input));
        }
    }
}

