/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.ISpawnTracker;
import io.github.lightman314.lightmanscurrency.common.capability.SpawnTrackerCapability;
import io.github.lightman314.lightmanscurrency.common.events.DroplistConfigGenerator;
import io.github.lightman314.lightmanscurrency.integration.alexsmobs.LCAlexsMobs;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class LootManager {
    public static final float LOOTING_MODIFIER = 0.01f;
    private static boolean lootTablesBuilt = false;
    private static LootPool.Builder ENTITY_LOOT_T1 = null;
    private static LootPool.Builder ENTITY_LOOT_T2 = null;
    private static LootPool.Builder ENTITY_LOOT_T3 = null;
    private static LootPool.Builder ENTITY_LOOT_T4 = null;
    private static LootPool.Builder ENTITY_LOOT_T5 = null;
    private static LootPool.Builder ENTITY_LOOT_T6 = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_T1 = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_T2 = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_T3 = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_T4 = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_T5 = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_T6 = null;
    private static LootPool.Builder CHEST_LOOT_T1 = null;
    private static LootPool.Builder CHEST_LOOT_T2 = null;
    private static LootPool.Builder CHEST_LOOT_T3 = null;
    private static LootPool.Builder CHEST_LOOT_T4 = null;
    private static LootPool.Builder CHEST_LOOT_T5 = null;
    private static LootPool.Builder CHEST_LOOT_T6 = null;

    public static void registerDroplistListeners() {
        DroplistConfigGenerator.registerEntityListener(LootManager::AddDefaultEntityEntries);
        DroplistConfigGenerator.registerChestListener(LootManager::AddDefaultChestEntries);
        LCAlexsMobs.registerDroplistListeners();
    }

    public static MobSpawnType deserializeSpawnReason(String reasonString) {
        return LootManager.deserializeSpawnReason(reasonString, MobSpawnType.NATURAL);
    }

    public static MobSpawnType deserializeSpawnReason(String reasonString, MobSpawnType defaultReason) {
        for (MobSpawnType reason : MobSpawnType.values()) {
            if (!reason.toString().contentEquals(reasonString)) continue;
            return reason;
        }
        LightmansCurrency.LogWarning("Reason string \"" + reasonString + "\" could not be properly deserialized. Returning the default spawn reason.");
        return defaultReason;
    }

    public static void AddDefaultEntityEntries(DroplistConfigGenerator.Entity event) {
        switch (event.getTier()) {
            case T1: {
                event.addVanillaEntry("slime");
                event.addVanillaEntry("silverfish");
                break;
            }
            case T2: {
                event.addVanillaEntry("zombie");
                event.addVanillaEntry("skeleton");
                event.addVanillaEntry("creeper");
                event.addVanillaEntry("spider");
                event.addVanillaEntry("cave_spider");
                event.addVanillaEntry("husk");
                event.addVanillaEntry("stray");
                event.addVanillaEntry("magma_cube");
                event.addVanillaEntry("zombie_villager");
                event.addVanillaEntry("drowned");
                break;
            }
            case T3: {
                event.addVanillaEntry("guardian");
                event.addVanillaEntry("elder_guardian");
                event.addVanillaEntry("phantom");
                event.addVanillaEntry("blaze");
                event.addVanillaEntry("ghast");
                event.addVanillaEntry("witch");
                event.addVanillaEntry("hoglin");
                event.addVanillaEntry("piglin_brute");
                event.addVanillaEntry("piglin");
                event.addVanillaEntry("zombified_piglin");
                break;
            }
            case T4: {
                event.addVanillaEntry("enderman");
                event.addVanillaEntry("evoker");
                event.addVanillaEntry("vindicator");
                event.addVanillaEntry("pillager");
                event.addVanillaEntry("ravager");
                event.addVanillaEntry("shulker");
                break;
            }
            case T5: {
                event.addVanillaEntry("wither_skeleton");
                break;
            }
            case BOSS_T4: {
                event.addVanillaEntry("warden");
                break;
            }
            case BOSS_T5: {
                event.addVanillaEntry("ender_dragon");
                break;
            }
            case BOSS_T6: {
                event.addVanillaEntry("wither");
            }
        }
    }

    public static void AddDefaultChestEntries(DroplistConfigGenerator.Chest event) {
        LightmansCurrency.LogDebug("Adding default vanilla chest entries of tier '" + event.getTier().toString() + "'");
        switch (event.getTier()) {
            case T1: {
                event.addVanillaEntry("underwater_ruin_small");
                event.addVanillaEntry("underwater_ruin_big");
                break;
            }
            case T3: {
                event.addVanillaEntry("jungle_temple");
                event.addVanillaEntry("nether_bridge");
                event.addVanillaEntry("simple_dungeon");
                event.addVanillaEntry("ruined_portal");
                break;
            }
            case T4: {
                event.addVanillaEntry("stronghold_crossing");
                event.addVanillaEntry("stronghold_corridor");
                event.addVanillaEntry("stronghold_library");
                event.addVanillaEntry("ancient_city");
                break;
            }
            case T5: {
                event.addVanillaEntry("buried_treasure");
                event.addVanillaEntry("bastion_hoglin_stable");
                event.addVanillaEntry("bastion_bridge");
                event.addVanillaEntry("bastion_other");
                event.addVanillaEntry("bastion_treasure");
                event.addVanillaEntry("end_city_treasure");
            }
        }
    }

    private static void confirmLootTablesGenerated() {
        if (lootTablesBuilt) {
            return;
        }
        LootManager.regenerateLootTables();
    }

    public static void regenerateLootTables() {
        Item lootItem1 = Config.COMMON.lootItem1.get();
        Item lootItem2 = Config.COMMON.lootItem2.get();
        Item lootItem3 = Config.COMMON.lootItem3.get();
        Item lootItem4 = Config.COMMON.lootItem4.get();
        Item lootItem5 = Config.COMMON.lootItem5.get();
        Item lootItem6 = Config.COMMON.lootItem6.get();
        ENTITY_LOOT_T1 = LootManager.GenerateEntityCoinPool(lootItem1, 1.0f, 10.0f, 0.75f, true);
        ENTITY_LOOT_T2 = LootManager.GenerateEntityCoinPool(lootItem2, 1.0f, 5.0f, 0.5f, true);
        ENTITY_LOOT_T3 = LootManager.GenerateEntityCoinPool(lootItem3, 1.0f, 5.0f, 0.25f, true);
        ENTITY_LOOT_T4 = LootManager.GenerateEntityCoinPool(lootItem4, 1.0f, 3.0f, 0.1f, true);
        ENTITY_LOOT_T5 = LootManager.GenerateEntityCoinPool(lootItem5, 1.0f, 3.0f, 0.05f, true);
        ENTITY_LOOT_T6 = LootManager.GenerateEntityCoinPool(lootItem6, 1.0f, 3.0f, 0.025f, true);
        ENTITY_LOOT_BOSS_T1 = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(lootItem1, 10.0f, 30.0f, 1.0f, false));
        ENTITY_LOOT_BOSS_T2 = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(lootItem1, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem2, 10.0f, 30.0f, 1.0f, false));
        ENTITY_LOOT_BOSS_T3 = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(lootItem1, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem2, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem3, 10.0f, 30.0f, 1.0f, false));
        ENTITY_LOOT_BOSS_T4 = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(lootItem1, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem2, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem3, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem4, 10.0f, 30.0f, 1.0f, false));
        ENTITY_LOOT_BOSS_T5 = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(lootItem1, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem2, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem3, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem4, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem5, 10.0f, 30.0f, 1.0f, false));
        ENTITY_LOOT_BOSS_T6 = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(lootItem1, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem2, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem3, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem4, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem5, 10.0f, 30.0f, 1.0f, false), (Object)LootManager.GenerateEntityCoinPool(lootItem6, 1.0f, 5.0f, 1.0f, false));
        CHEST_LOOT_T1 = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER}, 1.0f, 5.0f);
        CHEST_LOOT_T2 = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON}, 1.0f, 5.0f);
        CHEST_LOOT_T3 = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD}, 2.0f, 6.0f);
        CHEST_LOOT_T4 = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD}, 3.0f, 6.0f);
        CHEST_LOOT_T5 = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND}, 3.0f, 6.0f);
        CHEST_LOOT_T6 = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND, ChestLootEntryData.NETHERITE}, 3.0f, 6.0f);
        lootTablesBuilt = true;
    }

    private static String getValueList(ForgeConfigSpec.ConfigValue<List<? extends String>> config) {
        StringBuilder buffer = new StringBuilder();
        List list = (List)config.get();
        for (String value : list) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("\"").append(value).append("\"");
        }
        return buffer.toString();
    }

    public static void debugLootConfigs() {
        LightmansCurrency.LogDebug("Lightman's Currency common configs have been loaded. Coin loot values are as follows.");
        LightmansCurrency.LogDebug("Chest T1: " + LootManager.getValueList(Config.COMMON.chestDropsT1));
        LightmansCurrency.LogDebug("Chest T2: " + LootManager.getValueList(Config.COMMON.chestDropsT2));
        LightmansCurrency.LogDebug("Chest T3: " + LootManager.getValueList(Config.COMMON.chestDropsT3));
        LightmansCurrency.LogDebug("Chest T4: " + LootManager.getValueList(Config.COMMON.chestDropsT4));
        LightmansCurrency.LogDebug("Chest T5: " + LootManager.getValueList(Config.COMMON.chestDropsT5));
        LightmansCurrency.LogDebug("Chest T6: " + LootManager.getValueList(Config.COMMON.chestDropsT6));
        LightmansCurrency.LogDebug("Entity T1: " + LootManager.getValueList(Config.COMMON.entityDropsT1));
        LightmansCurrency.LogDebug("Entity T2: " + LootManager.getValueList(Config.COMMON.entityDropsT2));
        LightmansCurrency.LogDebug("Entity T3: " + LootManager.getValueList(Config.COMMON.entityDropsT3));
        LightmansCurrency.LogDebug("Entity T4: " + LootManager.getValueList(Config.COMMON.entityDropsT4));
        LightmansCurrency.LogDebug("Entity T5: " + LootManager.getValueList(Config.COMMON.entityDropsT5));
        LightmansCurrency.LogDebug("Entity T6: " + LootManager.getValueList(Config.COMMON.entityDropsT6));
        LightmansCurrency.LogDebug("Boss Entity T1: " + LootManager.getValueList(Config.COMMON.bossEntityDropsT1));
        LightmansCurrency.LogDebug("Entity Iron (Boss): " + LootManager.getValueList(Config.COMMON.bossEntityDropsT2));
        LightmansCurrency.LogDebug("Entity Gold (Boss): " + LootManager.getValueList(Config.COMMON.bossEntityDropsT3));
        LightmansCurrency.LogDebug("Entity Emerald (Boss): " + LootManager.getValueList(Config.COMMON.bossEntityDropsT4));
        LightmansCurrency.LogDebug("Entity Diamond (Boss): " + LootManager.getValueList(Config.COMMON.bossEntityDropsT5));
        LightmansCurrency.LogDebug("Entity Netherite (Boss): " + LootManager.getValueList(Config.COMMON.bossEntityDropsT6));
    }

    @SubscribeEvent
    public static void onEntitySpawned(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        ISpawnTracker tracker = SpawnTrackerCapability.lazyGetSpawnerTracker((LivingEntity)entity);
        if (tracker == null) {
            LightmansCurrency.LogDebug("Entity of type '" + ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString() + "' does not have a ISpawnTracker attached. Unable to flag it's SpawnReason.");
        } else {
            tracker.setSpawnReason(event.getSpawnType());
        }
    }

    @SubscribeEvent
    public static void attachSpawnTrackerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Mob) {
            event.addCapability(CurrencyCapabilities.ID_SPAWN_TRACKER, SpawnTrackerCapability.createProvider((LivingEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        ISpawnTracker tracker;
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (!((Boolean)Config.COMMON.enableSpawnerEntityDrops.get()).booleanValue() && (tracker = SpawnTrackerCapability.lazyGetSpawnerTracker(entity)) != null && tracker.spawnReason() == MobSpawnType.SPAWNER) {
            LightmansCurrency.LogDebug(entity.m_7755_().getString() + " did not drop coins, as it was spawned by a spawner.");
            return;
        }
        String name = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        if (event.getSource().m_7640_() instanceof Player || event.getSource().m_7639_() instanceof Player) {
            Player player;
            Player player2 = player = event.getSource().m_7640_() instanceof Player ? (Player)event.getSource().m_7640_() : (Player)event.getSource().m_7639_();
            if (player instanceof FakePlayer && !((Boolean)Config.COMMON.allowFakePlayerCoinDrops.get()).booleanValue()) {
                return;
            }
            if (((List)Config.COMMON.entityDropsT1.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.T1);
            } else if (((List)Config.COMMON.entityDropsT2.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.T2);
            } else if (((List)Config.COMMON.entityDropsT3.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.T3);
            } else if (((List)Config.COMMON.entityDropsT4.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.T4);
            } else if (((List)Config.COMMON.entityDropsT5.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.T5);
            } else if (((List)Config.COMMON.entityDropsT6.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.T6);
            } else if (((List)Config.COMMON.bossEntityDropsT1.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.BOSS_T1);
            } else if (((List)Config.COMMON.bossEntityDropsT2.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.BOSS_T2);
            } else if (((List)Config.COMMON.bossEntityDropsT3.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.BOSS_T3);
            } else if (((List)Config.COMMON.bossEntityDropsT4.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.BOSS_T4);
            } else if (((List)Config.COMMON.bossEntityDropsT5.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.BOSS_T5);
            } else if (((List)Config.COMMON.bossEntityDropsT6.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)entity, player, EntityPoolLevel.BOSS_T6);
            }
            return;
        }
        if (((List)Config.COMMON.bossEntityDropsT1.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)entity, null, EntityPoolLevel.BOSS_T1);
        } else if (((List)Config.COMMON.bossEntityDropsT2.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)entity, null, EntityPoolLevel.BOSS_T2);
        } else if (((List)Config.COMMON.bossEntityDropsT3.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)entity, null, EntityPoolLevel.BOSS_T3);
        } else if (((List)Config.COMMON.bossEntityDropsT4.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)entity, null, EntityPoolLevel.BOSS_T4);
        } else if (((List)Config.COMMON.bossEntityDropsT5.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)entity, null, EntityPoolLevel.BOSS_T5);
        } else if (((List)Config.COMMON.bossEntityDropsT6.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)entity, null, EntityPoolLevel.BOSS_T6);
        }
    }

    public static void validateEntityDropList() {
        LootManager.validateDropList(Config.COMMON.entityDropsT1);
        LootManager.validateDropList(Config.COMMON.entityDropsT2);
        LootManager.validateDropList(Config.COMMON.entityDropsT3);
        LootManager.validateDropList(Config.COMMON.entityDropsT4);
        LootManager.validateDropList(Config.COMMON.entityDropsT5);
        LootManager.validateDropList(Config.COMMON.entityDropsT6);
        LootManager.validateDropList(Config.COMMON.bossEntityDropsT1);
        LootManager.validateDropList(Config.COMMON.bossEntityDropsT2);
        LootManager.validateDropList(Config.COMMON.bossEntityDropsT3);
        LootManager.validateDropList(Config.COMMON.bossEntityDropsT4);
        LootManager.validateDropList(Config.COMMON.bossEntityDropsT5);
        LootManager.validateDropList(Config.COMMON.bossEntityDropsT6);
    }

    private static void validateDropList(ForgeConfigSpec.ConfigValue<List<? extends String>> config) {
        List configList = (List)config.get();
        ArrayList list = Lists.newArrayList();
        list.addAll(configList);
        boolean modified = false;
        for (int i = 0; i < list.size(); ++i) {
            String value = (String)list.get(i);
            if (value.contains("entities/")) {
                value = value.replace("entities/", "");
                list.set(i, value);
                modified = true;
            }
            if (!value.contains("entities\\")) continue;
            value = value.replace("entities\\", "");
            list.set(i, value);
            modified = true;
        }
        if (modified) {
            config.set((Object)list);
        }
    }

    private static String getSafeId(@Nonnull Entity entity) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (id == null) {
            return "null";
        }
        return id.toString().replace(':', '_');
    }

    private static void DropEntityLoot(Entity entity, Player player, EntityPoolLevel coinPool) {
        if (!((Boolean)Config.COMMON.enableEntityDrops.get()).booleanValue()) {
            return;
        }
        LootManager.confirmLootTablesGenerated();
        LootTable.Builder tableBuilder = LootTable.m_79147_();
        LootParams.Builder parameterBuilder = new LootParams.Builder((ServerLevel)entity.m_9236_());
        if (player != null) {
            parameterBuilder.m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81456_, (Object)player);
        }
        LootParams params = parameterBuilder.m_287235_(new LootContextParamSet.Builder().m_81408_(LootContextParams.f_81456_).m_81408_(LootContextParams.f_81458_).m_81405_());
        LootContext context = new LootContext.Builder(params).m_287259_(new ResourceLocation("lightmanscurrency", "generated_entity_loot/" + LootManager.getSafeId(entity)));
        try {
            if (coinPool == EntityPoolLevel.BOSS_T1) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_T1) {
                    tableBuilder.m_79161_(builder);
                }
                tableBuilder.m_79167_().m_79148_(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == EntityPoolLevel.BOSS_T2) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_T2) {
                    tableBuilder.m_79161_(builder);
                }
                tableBuilder.m_79167_().m_79148_(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == EntityPoolLevel.BOSS_T3) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_T3) {
                    tableBuilder.m_79161_(builder);
                }
                tableBuilder.m_79167_().m_79148_(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == EntityPoolLevel.BOSS_T4) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_T4) {
                    tableBuilder.m_79161_(builder);
                }
                tableBuilder.m_79167_().m_79148_(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == EntityPoolLevel.BOSS_T5) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_T5) {
                    tableBuilder.m_79161_(builder);
                }
                tableBuilder.m_79167_().m_79148_(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == EntityPoolLevel.BOSS_T6) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_T6) {
                    tableBuilder.m_79161_(builder);
                }
                tableBuilder.m_79167_().m_79148_(context, LootManager.LootSpawner(entity));
                return;
            }
            tableBuilder.m_79161_(ENTITY_LOOT_T1);
            if (coinPool != EntityPoolLevel.T1) {
                tableBuilder.m_79161_(ENTITY_LOOT_T2);
                if (coinPool != EntityPoolLevel.T2) {
                    tableBuilder.m_79161_(ENTITY_LOOT_T3);
                    if (coinPool != EntityPoolLevel.T3) {
                        tableBuilder.m_79161_(ENTITY_LOOT_T4);
                        if (coinPool != EntityPoolLevel.T4) {
                            tableBuilder.m_79161_(ENTITY_LOOT_T5);
                            if (coinPool != EntityPoolLevel.T5) {
                                tableBuilder.m_79161_(ENTITY_LOOT_T6);
                            }
                        }
                    }
                }
            }
            tableBuilder.m_79167_().m_79148_(context, LootManager.LootSpawner(entity));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error spawning coin drops!", e);
        }
    }

    public static List<ItemStack> GetRandomChestLoot(ChestPoolLevel coinPool, LootContext context) {
        LootManager.confirmLootTablesGenerated();
        try {
            if (coinPool == ChestPoolLevel.T1) {
                LootTable.Builder table = LootTable.m_79147_();
                table.m_79161_(CHEST_LOOT_T1);
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == ChestPoolLevel.T2) {
                LootTable.Builder table = LootTable.m_79147_();
                table.m_79161_(CHEST_LOOT_T2);
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == ChestPoolLevel.T3) {
                LootTable.Builder table = LootTable.m_79147_();
                table.m_79161_(CHEST_LOOT_T3);
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == ChestPoolLevel.T4) {
                LootTable.Builder table = LootTable.m_79147_();
                table.m_79161_(CHEST_LOOT_T4);
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == ChestPoolLevel.T5) {
                LootTable.Builder table = LootTable.m_79147_();
                table.m_79161_(CHEST_LOOT_T5);
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == ChestPoolLevel.T6) {
                LootTable.Builder table = LootTable.m_79147_();
                table.m_79161_(CHEST_LOOT_T6);
                return LootManager.safelyGetResults(table, context);
            }
            LightmansCurrency.LogError("Attempting to get random chest loot from an invalid chest pool level of '" + (coinPool == null ? "NULL" : coinPool.toString()) + "'");
            return new ArrayList<ItemStack>();
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error spawning chest coin drops!", e);
            return new ArrayList<ItemStack>();
        }
    }

    private static List<ItemStack> safelyGetResults(LootTable.Builder table, LootContext context) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        table.m_79167_().m_79131_(context, results::add);
        return results;
    }

    public static ChestPoolLevel GetChestPoolLevel(String lootTable) {
        if (((List)Config.COMMON.chestDropsT1.get()).contains(lootTable)) {
            return ChestPoolLevel.T1;
        }
        if (((List)Config.COMMON.chestDropsT2.get()).contains(lootTable)) {
            return ChestPoolLevel.T2;
        }
        if (((List)Config.COMMON.chestDropsT3.get()).contains(lootTable)) {
            return ChestPoolLevel.T3;
        }
        if (((List)Config.COMMON.chestDropsT4.get()).contains(lootTable)) {
            return ChestPoolLevel.T4;
        }
        if (((List)Config.COMMON.chestDropsT5.get()).contains(lootTable)) {
            return ChestPoolLevel.T5;
        }
        if (((List)Config.COMMON.chestDropsT6.get()).contains(lootTable)) {
            return ChestPoolLevel.T6;
        }
        return null;
    }

    private static Consumer<ItemStack> LootSpawner(Entity entity) {
        return i -> InventoryUtil.dumpContents(entity.m_9236_(), entity.m_20183_(), i);
    }

    private static LootPool.Builder GenerateEntityCoinPool(Item item, float min, float max, float chance, boolean requirePlayerKill) {
        LootPool.Builder lootPoolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
        if (requirePlayerKill) {
            lootPoolBuilder.m_79080_(LootItemKilledByPlayerCondition.m_81901_());
        }
        if (chance < 1.0f) {
            lootPoolBuilder.m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)chance, (float)0.01f));
        }
        return lootPoolBuilder;
    }

    private static LootPool.Builder GenerateChestCoinPool(ChestLootEntryData[] lootEntries, float minRolls, float maxRolls) {
        LootPool.Builder lootPoolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)minRolls, (float)maxRolls));
        for (ChestLootEntryData entry : lootEntries) {
            lootPoolBuilder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)entry.item.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)entry.minCount, (float)entry.maxCount))).m_79707_(entry.weight));
        }
        return lootPoolBuilder;
    }

    public static enum EntityPoolLevel {
        T1(false),
        T2(false),
        T3(false),
        T4(false),
        T5(false),
        T6(false),
        BOSS_T1(true),
        BOSS_T2(true),
        BOSS_T3(true),
        BOSS_T4(true),
        BOSS_T5(true),
        BOSS_T6(true);

        public final boolean isBoss;

        private EntityPoolLevel(boolean isBoss) {
            this.isBoss = isBoss;
        }
    }

    public static enum ChestPoolLevel {
        T1,
        T2,
        T3,
        T4,
        T5,
        T6;

    }

    private record ChestLootEntryData(Supplier<Item> item, float minCount, float maxCount, int weight) {
        public static ChestLootEntryData COPPER = new ChestLootEntryData(Config.COMMON.lootItem1, 1.0f, 10.0f, 1);
        public static ChestLootEntryData IRON = new ChestLootEntryData(Config.COMMON.lootItem2, 1.0f, 10.0f, 2);
        public static ChestLootEntryData GOLD = new ChestLootEntryData(Config.COMMON.lootItem3, 1.0f, 10.0f, 3);
        public static ChestLootEntryData EMERALD = new ChestLootEntryData(Config.COMMON.lootItem4, 1.0f, 10.0f, 4);
        public static ChestLootEntryData DIAMOND = new ChestLootEntryData(Config.COMMON.lootItem5, 1.0f, 8.0f, 5);
        public static ChestLootEntryData NETHERITE = new ChestLootEntryData(Config.COMMON.lootItem6, 1.0f, 3.0f, 6);
    }
}

