/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.enchantments.WalletEnchantment;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class WalletItem
extends Item {
    private static final SoundEvent emptyOpenSound = SoundEvents.f_11678_;
    private final ResourceLocation MODEL_TEXTURE;
    private final int level;
    private final int storageSize;

    public WalletItem(int level, int storageSize, String modelName, Item.Properties properties) {
        super(properties.m_41487_(1));
        this.level = level;
        this.storageSize = storageSize;
        WalletMenuBase.updateMaxWalletSlots(this.storageSize);
        this.MODEL_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/entity/" + modelName + ".png");
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (!LightmansCurrency.isCuriosLoaded()) {
            return null;
        }
        return LCCurios.createWalletProvider(stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 10;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return true;
    }

    public static boolean validWalletStack(ItemStack walletStack) {
        if (walletStack.m_41619_()) {
            return true;
        }
        return WalletItem.isWallet(walletStack.m_41720_());
    }

    public static boolean isWallet(ItemStack item) {
        return WalletItem.isWallet(item.m_41720_());
    }

    public static boolean isWallet(Item item) {
        return item instanceof WalletItem;
    }

    public static boolean CanConvert(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)Config.SERVER.walletConvertLevel.get() || wallet.level >= (Integer)Config.SERVER.walletPickupLevel.get();
    }

    public static boolean CanPickup(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)Config.SERVER.walletPickupLevel.get();
    }

    public static boolean HasBankAccess(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)Config.SERVER.walletBankLevel.get();
    }

    public static int InventorySize(WalletItem wallet) {
        if (wallet == null) {
            return 0;
        }
        return wallet.storageSize;
    }

    public static int InventorySize(ItemStack wallet) {
        if (wallet.m_41720_() instanceof WalletItem) {
            return WalletItem.InventorySize((WalletItem)wallet.m_41720_());
        }
        return 0;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        if (WalletItem.CanPickup(this)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.lightmanscurrency.wallet.pickup").m_130940_(ChatFormatting.YELLOW));
        }
        if (WalletItem.CanConvert(this)) {
            if (WalletItem.CanPickup(this)) {
                MutableComponent onOffText = WalletItem.getAutoConvert(stack) ? Component.m_237115_((String)"tooltip.lightmanscurrency.wallet.autoConvert.on").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.lightmanscurrency.wallet.autoConvert.off").m_130940_(ChatFormatting.RED);
                tooltip.add((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.wallet.autoConvert", (Object[])new Object[]{onOffText}).m_130940_(ChatFormatting.YELLOW));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.lightmanscurrency.wallet.manualConvert").m_130940_(ChatFormatting.YELLOW));
            }
        }
        if (WalletItem.HasBankAccess(this)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.lightmanscurrency.wallet.bankaccount").m_130940_(ChatFormatting.YELLOW));
        }
        WalletEnchantment.addWalletEnchantmentTooltips(tooltip, stack);
        CoinValue contents = CoinValue.fromInventory(WalletItem.getWalletInventory(stack));
        if (contents.getValueNumber() > 0L) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.wallet.storedmoney", (Object[])new Object[]{Component.m_237113_((String)contents.getString()).m_130940_(ChatFormatting.DARK_GREEN)}).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack wallet = player.m_21120_(hand);
        if (!world.f_46443_) {
            int walletSlot = WalletItem.GetWalletSlot(player.m_150109_(), wallet);
            if (walletSlot >= 0) {
                if (player.m_6047_() && !LightmansCurrency.isCuriosValid((LivingEntity)player)) {
                    boolean equippedWallet = false;
                    IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player);
                    if (walletHandler != null && walletHandler.getWallet().m_41619_()) {
                        walletHandler.setWallet(wallet);
                        player.m_21008_(hand, ItemStack.f_41583_);
                        LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new SPacketSyncWallet(player.m_19879_(), walletHandler.getWallet(), walletHandler.visible()));
                        walletHandler.clean();
                        equippedWallet = true;
                    }
                    if (equippedWallet) {
                        walletSlot = -1;
                    }
                }
                WalletMenuBase.SafeOpenWalletMenu((ServerPlayer)player, walletSlot);
            } else {
                LightmansCurrency.LogError("Could not find the wallet in the players inventory!");
            }
        } else {
            player.m_9236_().m_5594_(player, player.m_20183_(), emptyOpenSound, SoundSource.PLAYERS, 0.75f, 1.25f + player.m_9236_().f_46441_.m_188501_() * 0.5f);
            if (!WalletItem.isEmpty(wallet)) {
                player.m_9236_().m_5594_(player, player.m_20183_(), (SoundEvent)ModSounds.COINS_CLINKING.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
            }
        }
        return InteractionResultHolder.m_19090_((Object)wallet);
    }

    public static boolean isEmpty(ItemStack wallet) {
        NonNullList<ItemStack> inventory = WalletItem.getWalletInventory(wallet);
        for (ItemStack stack : inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private static int GetWalletSlot(Inventory inventory, ItemStack wallet) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i) != wallet) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack PickupCoin(ItemStack wallet, ItemStack coins) {
        ItemStack returnValue = coins.m_41777_();
        NonNullList<ItemStack> inventory = WalletItem.getWalletInventory(wallet);
        for (int i = 0; i < inventory.size() && !returnValue.m_41619_(); ++i) {
            ItemStack thisStack = (ItemStack)inventory.get(i);
            if (thisStack.m_41619_()) {
                inventory.set(i, (Object)returnValue.m_41777_());
                returnValue = ItemStack.f_41583_;
                continue;
            }
            if (thisStack.m_41720_() != returnValue.m_41720_()) continue;
            int amountToAdd = MathUtil.clamp(returnValue.m_41613_(), 0, thisStack.m_41741_() - thisStack.m_41613_());
            thisStack.m_41764_(thisStack.m_41613_() + amountToAdd);
            returnValue.m_41764_(returnValue.m_41613_() - amountToAdd);
        }
        inventory = WalletItem.getAutoConvert(wallet) ? WalletItem.ConvertCoins(inventory) : MoneyUtil.SortCoins(inventory);
        WalletItem.putWalletInventory(wallet, inventory);
        return returnValue;
    }

    private static NonNullList<ItemStack> ConvertCoins(NonNullList<ItemStack> inventory) {
        inventory = MoneyUtil.ExchangeAllCoinsUp(inventory);
        return MoneyUtil.SortCoins(inventory);
    }

    public static void putWalletInventory(ItemStack wallet, NonNullList<ItemStack> inventory) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return;
        }
        CompoundTag compound = wallet.m_41784_();
        ListTag invList = new ListTag();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack thisStack = (ItemStack)inventory.get(i);
            if (thisStack.m_41619_()) continue;
            CompoundTag thisItemCompound = thisStack.m_41739_(new CompoundTag());
            thisItemCompound.m_128344_("Slot", (byte)i);
            invList.add((Object)thisItemCompound);
        }
        compound.m_128365_("Items", (Tag)invList);
    }

    public static NonNullList<ItemStack> getWalletInventory(ItemStack wallet) {
        CompoundTag compound = wallet.m_41784_();
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
        }
        NonNullList value = NonNullList.m_122780_((int)WalletItem.InventorySize((WalletItem)wallet.m_41720_()), (Object)ItemStack.f_41583_);
        if (!compound.m_128441_("Items")) {
            return value;
        }
        ListTag invList = compound.m_128437_("Items", 10);
        for (int i = 0; i < invList.size(); ++i) {
            CompoundTag thisCompound = invList.m_128728_(i);
            ItemStack thisStack = ItemStack.m_41712_((CompoundTag)thisCompound);
            int j = thisCompound.m_128445_("Slot") & 0xFF;
            if (j >= value.size()) continue;
            value.set(j, (Object)thisStack);
        }
        return value;
    }

    public static boolean getAutoConvert(ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return false;
        }
        if (!WalletItem.CanConvert((WalletItem)wallet.m_41720_()) || !WalletItem.CanPickup((WalletItem)wallet.m_41720_())) {
            return false;
        }
        CompoundTag tag = wallet.m_41784_();
        if (!tag.m_128441_("AutoConvert")) {
            tag.m_128379_("AutoConvert", true);
            return true;
        }
        return tag.m_128471_("AutoConvert");
    }

    public static void toggleAutoConvert(ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return;
        }
        if (!WalletItem.CanConvert((WalletItem)wallet.m_41720_())) {
            return;
        }
        CompoundTag tag = wallet.m_41784_();
        boolean oldValue = WalletItem.getAutoConvert(wallet);
        tag.m_128379_("AutoConvert", !oldValue);
    }

    public static void CopyWalletContents(ItemStack walletIn, ItemStack walletOut) {
        WalletItem walletItemIn;
        Item item;
        block8: {
            block7: {
                item = walletIn.m_41720_();
                if (!(item instanceof WalletItem)) break block7;
                walletItemIn = (WalletItem)item;
                item = walletOut.m_41720_();
                if (item instanceof WalletItem) break block8;
            }
            LightmansCurrency.LogError("WalletItem.CopyWalletContents() -> One or both of the wallet stacks are not WalletItems.");
            return;
        }
        WalletItem walletItemOut = (WalletItem)item;
        NonNullList<ItemStack> walletInventory1 = WalletItem.getWalletInventory(walletIn);
        NonNullList<ItemStack> walletInventory2 = WalletItem.getWalletInventory(walletOut);
        if (walletInventory1.size() > walletInventory2.size()) {
            LightmansCurrency.LogWarning("WalletItem.CopyWalletContents() -> walletIn has a larger inventory size than walletOut. This may result in a loss of wallet contents.");
        }
        for (int i = 0; i < walletInventory1.size() && i < walletInventory2.size(); ++i) {
            walletInventory2.set(i, (Object)((ItemStack)walletInventory1.get(i)).m_41777_());
        }
        WalletItem.putWalletInventory(walletOut, walletInventory2);
        if (WalletItem.CanConvert(walletItemIn) && WalletItem.CanConvert(walletItemOut) && WalletItem.CanPickup(walletItemIn) && WalletItem.CanPickup(walletItemOut) && WalletItem.getAutoConvert(walletIn) != WalletItem.getAutoConvert(walletOut)) {
            WalletItem.toggleAutoConvert(walletOut);
        }
        if (walletIn.m_41788_()) {
            walletOut.m_41714_(walletIn.m_41786_());
        }
        EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)walletIn), (ItemStack)walletOut);
    }

    public static void QuickCollect(Player player, Container container) {
        WalletItem.QuickCollect(player, container, false);
    }

    public static void QuickCollect(Player player, Container container, boolean allowHidden) {
        ItemStack wallet = LightmansCurrency.getWalletStack(player);
        if (WalletItem.isWallet(wallet)) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!MoneyUtil.isCoin(stack, allowHidden)) continue;
                stack = WalletItem.PickupCoin(wallet, stack);
                container.m_6836_(i, stack);
            }
        }
    }

    public ResourceLocation getModelTexture() {
        return this.MODEL_TEXTURE;
    }
}

