/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.items.tooltips.LCTooltips;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CashRegisterItem
extends BlockItem {
    private static final SoundEvent soundEffect = SoundEvents.f_11871_;

    public CashRegisterItem(Block block, Item.Properties properties) {
        super(block, properties.m_41487_(1));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos lookPos = context.m_8083_();
        Level level = context.m_43725_();
        Block block = level.m_8055_(lookPos).m_60734_();
        if (block instanceof ITraderBlock) {
            ITraderBlock block2 = (ITraderBlock)block;
            BlockEntity blockEntity = block2.getBlockEntity(level.m_8055_(lookPos), (LevelAccessor)level, lookPos);
            if (!this.HasEntity(context.m_43722_(), blockEntity) && blockEntity instanceof TraderBlockEntity) {
                this.AddEntity(context.m_43722_(), blockEntity);
                if (level.f_46443_) {
                    level.m_5594_(context.m_43723_(), blockEntity.m_58899_(), soundEffect, SoundSource.NEUTRAL, 1.0f, 0.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof TraderBlockEntity) {
                if (level.f_46443_) {
                    level.m_5594_(context.m_43723_(), blockEntity.m_58899_(), soundEffect, SoundSource.NEUTRAL, 1.0f, 1.35f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    private boolean HasEntity(ItemStack stack, BlockEntity blockEntity) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        assert (tag != null);
        if (!tag.m_128441_("TraderPos")) {
            return false;
        }
        ListTag storageList = tag.m_128437_("TraderPos", 10);
        for (int i = 0; i < storageList.size(); ++i) {
            CompoundTag thisEntry = storageList.m_128728_(i);
            if (!thisEntry.m_128441_("x") || !thisEntry.m_128441_("y") || !thisEntry.m_128441_("z") || thisEntry.m_128451_("x") != blockEntity.m_58899_().m_123341_() || thisEntry.m_128451_("y") != blockEntity.m_58899_().m_123342_() || thisEntry.m_128451_("z") != blockEntity.m_58899_().m_123343_()) continue;
            return true;
        }
        return false;
    }

    private void AddEntity(ItemStack stack, BlockEntity blockEntity) {
        CompoundTag tag = stack.m_41784_();
        ListTag storageList = tag.m_128441_("TraderPos") ? tag.m_128437_("TraderPos", 10) : new ListTag();
        CompoundTag newEntry = new CompoundTag();
        newEntry.m_128405_("x", blockEntity.m_58899_().m_123341_());
        newEntry.m_128405_("y", blockEntity.m_58899_().m_123342_());
        newEntry.m_128405_("z", blockEntity.m_58899_().m_123343_());
        storageList.add((Object)newEntry);
        tag.m_128365_("TraderPos", (Tag)storageList);
    }

    private List<BlockPos> readNBT(ItemStack stack) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (!stack.m_41782_()) {
            return positions;
        }
        CompoundTag tag = stack.m_41783_();
        assert (tag != null);
        if (tag.m_128441_("TraderPos")) {
            ListTag list = tag.m_128437_("TraderPos", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag thisPos = list.m_128728_(i);
                if (!thisPos.m_128441_("x") || !thisPos.m_128441_("y") || !thisPos.m_128441_("z")) continue;
                positions.add(new BlockPos(thisPos.m_128451_("x"), thisPos.m_128451_("y"), thisPos.m_128451_("z")));
            }
        }
        return positions;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        List<BlockPos> data = this.readNBT(stack);
        TooltipItem.addTooltipAlways(tooltip, LCTooltips.CASH_REGISTER);
        tooltip.add((Component)Component.m_237110_((String)"tooptip.lightmanscurrency.cash_register", (Object[])new Object[]{data.size()}));
        if (!Screen.m_96638_() || data.size() == 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooptip.lightmanscurrency.cash_register.instructions"));
        }
        if (Screen.m_96638_()) {
            for (int i = 0; i < data.size(); ++i) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.cash_register.details", (Object[])new Object[]{i + 1, data.get(i).m_123341_(), data.get(i).m_123342_(), data.get(i).m_123343_()}));
            }
        } else if (data.size() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooptip.lightmanscurrency.cash_register.holdshift").m_130940_(ChatFormatting.YELLOW));
        }
    }
}

