/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class CoinMintRecipeSerializer
implements RecipeSerializer<CoinMintRecipe> {
    @NotNull
    public CoinMintRecipe fromJson(@NotNull ResourceLocation recipeId, JsonObject json) {
        if (!json.has("ingredient")) {
            throw new JsonSyntaxException("Missing ingredient, expected to find an item.");
        }
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("ingredient"));
        int ingredientCount = 1;
        if (json.has("count")) {
            ingredientCount = json.get("count").getAsInt();
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result. Expected to find an item.");
        }
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)json.get("result").getAsJsonObject());
        if (result.m_41619_()) {
            throw new JsonSyntaxException("Result is empty.");
        }
        CoinMintRecipe.MintType type = CoinMintRecipe.MintType.OTHER;
        if (json.has("mintType")) {
            type = CoinMintRecipe.readType(json.get("mintType"));
        }
        int duration = 0;
        if (json.has("duration")) {
            duration = json.get("duration").getAsInt();
        }
        return new CoinMintRecipe(recipeId, type, duration, ingredient, ingredientCount, result);
    }

    public CoinMintRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        CoinMintRecipe.MintType type = CoinMintRecipe.readType(buffer.m_130277_());
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int ingredientCount = buffer.readInt();
        ItemStack result = buffer.m_130267_();
        int duration = buffer.readInt();
        return new CoinMintRecipe(recipeId, type, duration, ingredient, ingredientCount, result);
    }

    public void toNetwork(FriendlyByteBuf buffer, CoinMintRecipe recipe) {
        buffer.m_130070_(recipe.getMintType().name());
        recipe.getIngredient().m_43923_(buffer);
        buffer.writeInt(recipe.ingredientCount);
        buffer.writeItemStack(recipe.getOutputItem(), false);
        buffer.writeInt(recipe.getInternalDuration());
    }
}

