/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CoinMintRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final MintType type;
    private final int duration;
    private final Ingredient ingredient;
    public final int ingredientCount;
    private final ItemStack result;

    public static MintType readType(JsonElement json) {
        try {
            return CoinMintRecipe.readType(json.getAsString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return MintType.OTHER;
        }
    }

    public static MintType readType(String typeName) {
        for (MintType type : MintType.values()) {
            if (!type.name().equals(typeName)) continue;
            return type;
        }
        return MintType.OTHER;
    }

    public CoinMintRecipe(ResourceLocation id, MintType type, int duration, Ingredient ingredient, int ingredientCount, ItemStack result) {
        this.id = id;
        this.type = type;
        this.duration = duration;
        this.ingredient = ingredient;
        this.ingredientCount = Math.max(ingredientCount, 1);
        this.result = result;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public MintType getMintType() {
        return this.type;
    }

    public boolean allowed() {
        if (this.type == MintType.MINT) {
            return (Boolean)Config.SERVER.allowCoinMinting.get() != false && Config.canMint(this.result.m_41720_());
        }
        if (this.type == MintType.MELT) {
            try {
                return (Boolean)Config.SERVER.allowCoinMelting.get() != false && Config.canMelt(this.ingredient.m_43908_()[0].m_41720_());
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    public boolean isValid() {
        return !this.ingredient.m_43947_() && this.result.m_41720_() != Items.f_41852_ && this.allowed();
    }

    public boolean m_5818_(@Nonnull Container inventory, @Nonnull Level level) {
        if (!this.isValid()) {
            return false;
        }
        ItemStack firstStack = inventory.m_8020_(0);
        return this.ingredient.test(firstStack);
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inventory, @Nonnull RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack getOutputItem() {
        return this.result.m_41777_();
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        if (this.isValid()) {
            return this.result.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public int getInternalDuration() {
        return this.duration;
    }

    public int getDuration() {
        return this.duration > 0 ? this.duration : (Integer)Config.SERVER.defaultMintDuration.get();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.COIN_MINT.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypes.COIN_MINT.get();
    }

    public static enum MintType {
        MINT,
        MELT,
        OTHER;

    }
}

