/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.capability;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.integration.curios.wallet.CuriosWalletHandler;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WalletCapability {
    @Deprecated
    public static LazyOptional<IWalletHandler> getWalletHandler(@Nonnull Entity entity) {
        return entity.getCapability(CurrencyCapabilities.WALLET);
    }

    @Nullable
    public static IWalletHandler lazyGetWalletHandler(@Nonnull Entity entity) {
        LazyOptional optional = entity.getCapability(CurrencyCapabilities.WALLET);
        if (optional.isPresent()) {
            return (IWalletHandler)optional.orElseThrow(() -> new RuntimeException("Unexpected error occurred!"));
        }
        return null;
    }

    @Nullable
    public static IWalletHandler getRenderWalletHandler(@Nonnull Entity entity) {
        if (LightmansCurrency.isCuriosLoaded() && entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            return new CuriosWalletHandler(le);
        }
        return WalletCapability.lazyGetWalletHandler(entity);
    }

    public static CoinValue getWalletMoney(@Nonnull Entity entity) {
        ItemStack wallet;
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler(entity);
        if (walletHandler != null && WalletItem.isWallet((wallet = walletHandler.getWallet()).m_41720_())) {
            return MoneyUtil.getCoinValue(WalletItem.getWalletInventory(wallet));
        }
        return CoinValue.EMPTY;
    }

    public static ICapabilityProvider createProvider(Player playerEntity) {
        return new Provider(playerEntity);
    }

    public static void WalletSlotInteraction(Player player, int clickedSlot, boolean heldShift, ItemStack heldItem) {
        IWalletHandler walletHandler;
        boolean creative;
        if (LightmansCurrency.isCuriosValid((LivingEntity)player)) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        boolean bl = creative = player.m_7500_() && !player.m_9236_().f_46443_;
        if (!creative) {
            heldItem = menu.m_142621_();
        }
        if ((walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player)) == null) {
            LightmansCurrency.LogWarning("Attempted to do a wallet slot interaction, but the player has no wallet handler.");
            return;
        }
        if (clickedSlot < 0) {
            ItemStack wallet = walletHandler.getWallet();
            if (heldShift) {
                if (wallet.m_41619_()) {
                    return;
                }
                if (player.m_150109_().m_36062_() >= 0) {
                    if (!creative) {
                        player.m_150109_().m_36054_(wallet);
                    }
                    walletHandler.setWallet(ItemStack.f_41583_);
                }
            } else {
                if (wallet.m_41619_() && heldItem.m_41619_()) {
                    return;
                }
                if (WalletSlot.isValidWallet(heldItem) || heldItem.m_41619_()) {
                    walletHandler.setWallet(heldItem);
                    if (!creative) {
                        menu.m_142503_(wallet);
                    }
                }
            }
        } else if (heldShift) {
            Inventory inventory = player.m_150109_();
            if (clickedSlot >= inventory.m_6643_()) {
                LightmansCurrency.LogWarning("Clicked on slot " + clickedSlot + " of " + player.m_150109_().m_6643_() + " on the " + DebugUtil.getSideText((Entity)player));
                return;
            }
            ItemStack slotItem = inventory.m_8020_(clickedSlot);
            if (WalletSlot.isValidWallet(slotItem) && walletHandler.getWallet().m_41619_()) {
                if (!creative) {
                    if (slotItem.m_41613_() > 1) {
                        inventory.m_7407_(clickedSlot, 1);
                    } else {
                        inventory.m_6836_(clickedSlot, ItemStack.f_41583_);
                    }
                }
                ItemStack newWallet = slotItem.m_41777_();
                newWallet.m_41764_(1);
                walletHandler.setWallet(newWallet);
            }
        }
    }

    private static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IWalletHandler> optional;
        final IWalletHandler handler;

        Provider(Player playerEntity) {
            this.handler = new WalletHandler((LivingEntity)playerEntity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CurrencyCapabilities.WALLET.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.save();
        }

        public void deserializeNBT(Tag tag) {
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                this.handler.load(compound);
            }
        }
    }

    public static class WalletHandler
    implements IWalletHandler {
        final LivingEntity entity;
        ItemStack walletItem;
        ItemStack backupWallet;
        boolean visible;
        boolean wasVisible;

        public WalletHandler(LivingEntity entity) {
            this.entity = entity;
            this.backupWallet = ItemStack.f_41583_;
            this.walletItem = ItemStack.f_41583_;
            this.visible = true;
            this.wasVisible = true;
        }

        @Override
        public ItemStack getWallet() {
            if (LightmansCurrency.isCuriosValid(this.entity)) {
                return LCCurios.getCuriosWalletContents(this.entity);
            }
            return this.walletItem;
        }

        @Override
        public void setWallet(ItemStack walletStack) {
            if (LightmansCurrency.isCuriosValid(this.entity)) {
                LCCurios.setCuriosWalletContents(this.entity, walletStack);
                return;
            }
            this.walletItem = walletStack;
            if (!(walletStack.m_41720_() instanceof WalletItem) && !walletStack.m_41619_()) {
                LightmansCurrency.LogWarning("Equipped a non-wallet to the players wallet slot.");
            }
        }

        @Override
        public void syncWallet(ItemStack walletStack) {
            this.walletItem = walletStack;
        }

        @Override
        public boolean visible() {
            if (LightmansCurrency.isCuriosValid(this.entity)) {
                return LCCurios.getCuriosWalletVisibility(this.entity);
            }
            return this.visible;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public LivingEntity entity() {
            return this.entity;
        }

        @Override
        public boolean isDirty() {
            return !InventoryUtil.ItemMatches(this.backupWallet, this.getWallet()) || this.backupWallet.m_41613_() != this.getWallet().m_41613_() || this.wasVisible != this.visible;
        }

        @Override
        public void clean() {
            this.backupWallet = this.walletItem.m_41777_();
            this.wasVisible = this.visible;
        }

        @Override
        public CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            CompoundTag walletItem = this.walletItem.m_41739_(new CompoundTag());
            compound.m_128365_("Wallet", (Tag)walletItem);
            compound.m_128379_("Visible", this.visible);
            return compound;
        }

        @Override
        public void load(CompoundTag compound) {
            this.walletItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Wallet"));
            if (compound.m_128441_("Visible")) {
                this.visible = compound.m_128471_("Visible");
            }
            this.clean();
        }

        @Override
        public void tick() {
            if (LightmansCurrency.isCuriosValid(this.entity) && !this.walletItem.m_41619_()) {
                LightmansCurrency.LogInfo("Curios detected. Moving wallet from Lightman's Currency wallet slot into the curios wallet slot.");
                LCCurios.setCuriosWalletContents(this.entity, this.walletItem);
                this.walletItem = ItemStack.f_41583_;
            }
        }
    }
}

