/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates;

import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IWideBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates.TraderBlockTallRotatable;
import io.github.lightman314.lightmanscurrency.common.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.util.TriFunction;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class TraderBlockTallWideRotatable
extends TraderBlockTallRotatable
implements IWideBlock {
    private final TriFunction<Direction, Boolean, Boolean, VoxelShape> shape;

    protected TraderBlockTallWideRotatable(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.TALL_WIDE_BOX_SHAPE_T);
    }

    protected TraderBlockTallWideRotatable(BlockBehaviour.Properties properties, VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
        this(properties, LazyShapes.lazyTallWideDirectionalShape(north, east, south, west));
    }

    protected TraderBlockTallWideRotatable(BlockBehaviour.Properties properties, BiFunction<Direction, Boolean, VoxelShape> tallShape) {
        this(properties, LazyShapes.lazyTallWideDirectionalShape(tallShape));
    }

    protected TraderBlockTallWideRotatable(BlockBehaviour.Properties properties, TriFunction<Direction, Boolean, Boolean, VoxelShape> shape) {
        super(properties);
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ISLEFT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected boolean shouldMakeTrader(BlockState state) {
        return this.getIsBottom(state) && this.getIsLeft(state);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shape.apply(this.getFacing(state), this.getIsBottom(state), this.getIsLeft(state));
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ISLEFT});
    }

    @Override
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)ISLEFT, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity player, @NotNull ItemStack stack) {
        BlockPos rightPos = IRotatableBlock.getRightPos(pos, this.getFacing(state));
        if (this.getReplacable(level, rightPos, state, player, stack) && this.getReplacable(level, rightPos.m_7494_(), state, player, stack) && this.getReplacable(level, pos.m_7494_(), state, player, stack)) {
            level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)ISLEFT, (Comparable)Boolean.valueOf(true)));
            level.m_46597_(rightPos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)ISLEFT, (Comparable)Boolean.valueOf(false)));
            level.m_46597_(rightPos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)ISLEFT, (Comparable)Boolean.valueOf(false)));
        } else {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
            if (player instanceof Player) {
                ItemStack giveStack = stack.m_41777_();
                giveStack.m_41764_(1);
                ((Player)player).m_150109_().m_36054_(giveStack);
            }
        }
        this.setPlacedByBase(level, pos, state, player, stack);
    }

    @Override
    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        TraderBlockEntity trader;
        this.playerWillDestroyBase(level, pos, state, player);
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof TraderBlockEntity && !(trader = (TraderBlockEntity)blockEntity).canBreak(player)) {
            return;
        }
        if (this.getIsBottom(state)) {
            this.setAir(level, pos.m_7494_(), player);
            otherPos = this.getOtherSide(pos, state, this.getFacing(state));
            this.setAir(level, otherPos, player);
            this.setAir(level, otherPos.m_7494_(), player);
        } else {
            this.setAir(level, pos.m_7495_(), player);
            otherPos = this.getOtherSide(pos, state, this.getFacing(state));
            this.setAir(level, otherPos, player);
            this.setAir(level, otherPos.m_7495_(), player);
        }
    }

    @Override
    protected void onInvalidRemoval(BlockState state, Level level, BlockPos pos, TraderData trader) {
        super.onInvalidRemoval(state, level, pos, trader);
        BlockPos otherPos = this.getOtherSide(pos, state, this.getFacing(state));
        this.setAir(level, otherPos, null);
        this.setAir(level, this.getOtherHeight(otherPos, state), null);
    }

    @Override
    public BlockEntity getBlockEntity(BlockState state, LevelAccessor level, BlockPos pos) {
        if (level == null) {
            return null;
        }
        BlockPos getPos = pos;
        if (this.getIsRight(state)) {
            getPos = IRotatableBlock.getLeftPos(getPos, this.getFacing(state));
        }
        if (this.getIsTop(state)) {
            return level.m_7702_(getPos.m_7495_());
        }
        return level.m_7702_(getPos);
    }
}

