/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.CapabilityInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IDeprecatedBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class TraderBlockBase
extends Block
implements ITraderBlock,
IEasyEntityBlock {
    private final VoxelShape shape;

    public TraderBlockBase(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.BOX_T);
    }

    public TraderBlockBase(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties);
        this.shape = shape != null ? shape : LazyShapes.BOX_T;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shape;
    }

    protected boolean shouldMakeTrader(BlockState state) {
        return true;
    }

    protected abstract BlockEntity makeTrader(BlockPos var1, BlockState var2);

    protected BlockEntity makeDummy(BlockPos pos, BlockState state) {
        return new CapabilityInterfaceBlockEntity(pos, state);
    }

    protected abstract BlockEntityType<?> traderType();

    protected List<BlockEntityType<?>> validTraderTypes() {
        return ImmutableList.of(this.traderType());
    }

    @Override
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return this.validTraderTypes();
    }

    public final BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (this.shouldMakeTrader(state)) {
            return this.makeTrader(pos, state);
        }
        return this.makeDummy(pos, state);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos)) instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            Object trader = traderSource.getTraderData();
            if (trader == null) {
                LightmansCurrency.LogWarning("Trader Data for block at " + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + " had to be re-initialized on interaction.");
                player.m_213846_((Component)Component.m_237115_((String)"trader.warning.reinitialized").m_130940_(ChatFormatting.RED));
                traderSource.initialize(player, ItemStack.f_41583_);
                trader = traderSource.getTraderData();
            }
            if (trader != null) {
                if (((TraderData)trader).shouldAlwaysShowOnTerminal()) {
                    ((TraderData)trader).openStorageMenu(player, BlockEntityValidator.of(traderSource));
                } else {
                    ((TraderData)trader).openTraderMenu(player, BlockEntityValidator.of(traderSource));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity player, @Nonnull ItemStack stack) {
        this.setPlacedByBase(level, pos, state, player, stack);
    }

    public final void setPlacedByBase(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
            if (blockEntity instanceof TraderBlockEntity) {
                TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
                traderSource.initialize(player, stack);
            } else {
                LightmansCurrency.LogError("Trader Block returned block entity of type '" + (blockEntity == null ? "null" : blockEntity.getClass().getName()) + "' when placing the block.");
            }
        }
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        this.playerWillDestroyBase(level, pos, state, player);
    }

    public final void playerWillDestroyBase(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            if (!traderSource.canBreak(player)) {
                return;
            }
            traderSource.flagAsLegitBreak();
            Object trader = traderSource.getTraderData();
            if (trader != null) {
                InventoryUtil.dumpContents(level, pos, ((TraderData)trader).getContents(level, pos, state, !player.m_7500_()));
            }
        } else {
            LightmansCurrency.LogError("Trader Block returned block entity of type '" + (blockEntity == null ? "null" : blockEntity.getClass().getName()) + "' when destroying the block.");
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean flag) {
        BlockEntity blockEntity;
        IDeprecatedBlock db;
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, flag);
            return;
        }
        Block block = state.m_60734_();
        if (block instanceof IDeprecatedBlock && (db = (IDeprecatedBlock)block).acceptableReplacementState(newState)) {
            return;
        }
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos)) instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            if (!traderSource.legitimateBreak()) {
                traderSource.flagAsLegitBreak();
                Object trader = traderSource.getTraderData();
                if (trader != null) {
                    LightmansCurrency.LogError("Trader block at " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + " was broken by illegal means!");
                    LightmansCurrency.LogError("Activating emergency eject protocol.");
                    EjectionData data = EjectionData.create(level, pos, state, trader);
                    EjectionSaveData.HandleEjectionData(level, pos, data);
                }
                try {
                    this.onInvalidRemoval(state, level, pos, (TraderData)trader);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                LightmansCurrency.LogInfo("Trader block was broken by legal means!");
            }
            traderSource.onBreak();
        }
        super.m_6810_(state, level, pos, newState, flag);
    }

    protected abstract void onInvalidRemoval(BlockState var1, Level var2, BlockPos var3, TraderData var4);

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return false;
    }

    @Override
    public BlockEntity getBlockEntity(BlockState state, LevelAccessor level, BlockPos pos) {
        return level == null ? null : level.m_7702_(pos);
    }

    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return ArrayList::new;
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, this.getItemTooltips());
        super.m_5871_(stack, level, tooltip, flagIn);
    }

    protected static void replaceTraderBlock(Level level, BlockPos pos, BlockState newState) {
        level.m_7731_(pos, newState, 35);
    }
}

