/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.common.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.tooltips.LCTooltips;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ShelfBlock
extends TraderBlockRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 1;
    private static final VoxelShape SHAPE_NORTH = ShelfBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    private static final VoxelShape SHAPE_SOUTH = ShelfBlock.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = ShelfBlock.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = ShelfBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties, LazyShapes.lazyDirectionalShape(SHAPE_NORTH, SHAPE_EAST, SHAPE_SOUTH, SHAPE_WEST));
    }

    @Override
    public BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new ItemTraderBlockEntity(pos, state, 1);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return (BlockEntityType)ModBlockEntities.ITEM_TRADER.get();
    }

    @Override
    public List<BlockEntityType<?>> validTraderTypes() {
        return ImmutableList.of((Object)((BlockEntityType)ModBlockEntities.ITEM_TRADER.get()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isDoubleTrade) {
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(1);
        if (tradeSlot == 0) {
            Direction facing = this.getFacing(state);
            Vector3f forward = IRotatableBlock.getForwardVect(facing);
            Vector3f right = IRotatableBlock.getRightVect(facing);
            Vector3f up = MathUtil.getYP();
            Vector3f offset = IRotatableBlock.getOffsetVect(facing);
            posList.add(MathUtil.VectorAdd(offset, MathUtil.VectorMult(right, 0.5f), MathUtil.VectorMult(forward, 0.90625f), MathUtil.VectorMult(up, 0.5625f)));
        }
        return posList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternionf> GetStackRenderRot(int tradeSlot, BlockState state) {
        ArrayList<Quaternionf> rotation = new ArrayList<Quaternionf>();
        int facing = this.getFacing(state).m_122416_();
        rotation.add(MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing * -90.0f));
        return rotation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float GetStackRenderScale(int tradeSlot, BlockState state) {
        return 0.875f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 1;
    }

    @Override
    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER;
    }
}

