/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks;

import io.github.lightman314.lightmanscurrency.common.blockentity.trader.FreezerTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates.TraderBlockTallRotatable;
import io.github.lightman314.lightmanscurrency.common.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.items.tooltips.LCTooltips;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FreezerBlock
extends TraderBlockTallRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 8;
    public static final VoxelShape SHAPE_SOUTH = FreezerBlock.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)32.0, (double)16.0);
    public static final VoxelShape SHAPE_NORTH = FreezerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)13.0);
    public static final VoxelShape SHAPE_EAST = FreezerBlock.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public static final VoxelShape SHAPE_WEST = FreezerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)32.0, (double)16.0);
    private final ResourceLocation doorModel;

    public FreezerBlock(BlockBehaviour.Properties properties, ResourceLocation doorModel) {
        super(properties, LazyShapes.lazyTallDirectionalShape(SHAPE_NORTH, SHAPE_EAST, SHAPE_SOUTH, SHAPE_WEST));
        this.doorModel = doorModel;
    }

    public ResourceLocation getDoorModel() {
        return this.doorModel;
    }

    public static ResourceLocation GenerateDoorModel(Color color) {
        return FreezerBlock.GenerateDoorModel("lightmanscurrency", color);
    }

    public static ResourceLocation GenerateDoorModel(String namespace, Color color) {
        return new ResourceLocation(namespace, "block/freezer/doors/" + color.toString().toLowerCase());
    }

    @Override
    public BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new FreezerTraderBlockEntity(pos, state, 8);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return (BlockEntityType)ModBlockEntities.FREEZER_TRADER.get();
    }

    @Override
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isDoubleTrade) {
        Direction facing = this.getFacing(state);
        Vector3f forward = IRotatableBlock.getForwardVect(facing);
        Vector3f right = IRotatableBlock.getRightVect(facing);
        Vector3f up = MathUtil.getYP();
        Vector3f offset = IRotatableBlock.getOffsetVect(facing);
        Vector3f forwardOffset = MathUtil.VectorMult(forward, 0.375f);
        Vector3f firstPosition = null;
        if (tradeSlot == 0) {
            rightOffset = MathUtil.VectorMult(right, 0.3125f);
            vertOffset = MathUtil.VectorMult(up, 1.75f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 1) {
            rightOffset = MathUtil.VectorMult(right, 0.6875f);
            vertOffset = MathUtil.VectorMult(up, 1.75f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 2) {
            rightOffset = MathUtil.VectorMult(right, 0.3125f);
            vertOffset = MathUtil.VectorMult(up, 1.3125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 3) {
            rightOffset = MathUtil.VectorMult(right, 0.6875f);
            vertOffset = MathUtil.VectorMult(up, 1.3125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 4) {
            rightOffset = MathUtil.VectorMult(right, 0.3125f);
            vertOffset = MathUtil.VectorMult(up, 0.875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 5) {
            rightOffset = MathUtil.VectorMult(right, 0.6875f);
            vertOffset = MathUtil.VectorMult(up, 0.875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 6) {
            rightOffset = MathUtil.VectorMult(right, 0.3125f);
            vertOffset = MathUtil.VectorMult(up, 0.4375f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 7) {
            rightOffset = MathUtil.VectorMult(right, 0.6875f);
            vertOffset = MathUtil.VectorMult(up, 0.4375f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        }
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(3);
        if (firstPosition != null) {
            posList.add(firstPosition);
            for (float distance = 3.2f; distance < 7.0f; distance += 3.2f) {
                posList.add(MathUtil.VectorAdd(firstPosition, MathUtil.VectorMult(forward, distance / 16.0f)));
            }
        } else {
            posList.add(new Vector3f(0.0f, 1.0f, 0.0f));
        }
        return posList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternionf> GetStackRenderRot(int tradeSlot, BlockState state) {
        ArrayList<Quaternionf> rotation = new ArrayList<Quaternionf>();
        int facing = this.getFacing(state).m_122416_();
        rotation.add(MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing * -90.0f));
        return rotation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float GetStackRenderScale(int tradeSlot, BlockState state) {
        return 0.4f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 8;
    }

    @Override
    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER;
    }
}

