/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks;

import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ArmorDisplayTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates.TraderBlockTallRotatable;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.tooltips.LCTooltips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ArmorDisplayBlock
extends TraderBlockTallRotatable
implements IItemTraderBlock {
    public ArmorDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity makeTrader(BlockPos pos, BlockState state) {
        ArmorDisplayTraderBlockEntity trader = new ArmorDisplayTraderBlockEntity(pos, state);
        trader.flagAsLoaded();
        return trader;
    }

    @Override
    public BlockEntityType<?> traderType() {
        return (BlockEntityType)ModBlockEntities.ARMOR_TRADER.get();
    }

    @Override
    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ArmorDisplayTraderBlockEntity) {
            ((ArmorDisplayTraderBlockEntity)blockEntity).destroyArmorStand();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isDoubleTrade) {
        return new ArrayList<Vector3f>();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternionf> GetStackRenderRot(int tradeSlot, BlockState state) {
        return new ArrayList<Quaternionf>();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float GetStackRenderScale(int tradeSlot, BlockState state) {
        return 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return -1;
    }

    @Override
    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER_ARMOR;
    }
}

