/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinMintBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.items.tooltips.LCTooltips;
import io.github.lightman314.lightmanscurrency.common.menus.MintMenu;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class CoinMintBlock
extends RotatableBlock
implements IEasyEntityBlock {
    private static final MutableComponent TITLE = Component.m_237115_((String)"gui.lightmanscurrency.coinmint.title");

    public CoinMintBlock(BlockBehaviour.Properties properties) {
        super(properties, CoinMintBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));
    }

    @Override
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return ImmutableList.of((Object)((BlockEntityType)ModBlockEntities.COIN_MINT.get()));
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CoinMintBlockEntity(pos, state);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        BlockEntity tileEntity;
        if (!level.f_46443_ && (tileEntity = level.m_7702_(pos)) instanceof CoinMintBlockEntity) {
            CoinMintBlockEntity mint = (CoinMintBlockEntity)tileEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new CoinMintMenuProvider(mint), (BlockPos)pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinMintBlockEntity) {
            CoinMintBlockEntity mintEntity = (CoinMintBlockEntity)blockEntity;
            mintEntity.dumpContents(level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, LCTooltips.COIN_MINT);
        super.m_5871_(stack, level, tooltip, flagIn);
    }

    private record CoinMintMenuProvider(CoinMintBlockEntity blockEntity) implements MenuProvider
    {
        public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new MintMenu(id, inventory, this.blockEntity);
        }

        @Nonnull
        public Component m_5446_() {
            return TITLE;
        }
    }
}

