/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PaygateBlockEntity
extends TraderBlockEntity<PaygateTraderData> {
    private int timer = 0;

    public PaygateBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.PAYGATE.get(), pos, state);
    }

    protected PaygateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.saveTimer(compound);
    }

    public final CompoundTag saveTimer(CompoundTag compound) {
        compound.m_128405_("Timer", Math.max(this.timer, 0));
        return compound;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        if (compound.m_128425_("Timer", 3)) {
            this.timer = Math.max(compound.m_128451_("Timer"), 0);
        }
        super.m_142466_(compound);
    }

    public boolean isActive() {
        return this.timer > 0;
    }

    public void activate(int duration) {
        this.timer = duration;
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.markTimerDirty();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.timer > 0) {
            --this.timer;
            this.markTimerDirty();
            if (this.timer <= 0) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void markTimerDirty() {
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveTimer(new CompoundTag()));
        }
    }

    public int getValidTicketTrade(Player player, ItemStack heldItem) {
        long ticketID;
        PaygateTraderData trader = (PaygateTraderData)this.getTraderData();
        if (TicketItem.isTicketOrPass(heldItem) && (ticketID = TicketItem.GetTicketID(heldItem)) >= -1L) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                PaygateTradeData trade = trader.getTrade(i);
                if (!trade.isTicketTrade() || trade.getTicketID() != ticketID || trader.runPreTradeEvent(PlayerReference.of(player), trade).isCanceled()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    @Nonnull
    protected PaygateTraderData buildNewTrader() {
        return new PaygateTraderData(this.f_58857_, this.f_58858_);
    }
}

