/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.bank;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.data.ClientBankData;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageInitializeClientBank;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageSelectBankAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageUpdateClientBank;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketSyncSelectedBankAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="lightmanscurrency")
public class BankSaveData
extends SavedData {
    private final Map<UUID, Pair<BankAccount, BankReference>> playerBankData = new HashMap<UUID, Pair<BankAccount, BankReference>>();

    private BankSaveData() {
    }

    private BankSaveData(CompoundTag compound) {
        ListTag bankData = compound.m_128437_("PlayerBankData", 10);
        for (int i = 0; i < bankData.size(); ++i) {
            CompoundTag tag = bankData.m_128728_(i);
            UUID player = tag.m_128342_("Player");
            BankAccount bankAccount = BankSaveData.loadBankAccount(player, tag.m_128469_("BankAccount"));
            BankReference lastSelected = BankReference.load(tag.m_128469_("LastSelected"));
            this.playerBankData.put(player, (Pair<BankAccount, BankReference>)Pair.of((Object)bankAccount, (Object)lastSelected));
        }
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag bankData = new ListTag();
        this.playerBankData.forEach((player, data) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("Player", player);
            tag.m_128365_("BankAccount", (Tag)((BankAccount)data.getFirst()).save());
            tag.m_128365_("LastSelected", (Tag)((BankReference)data.getSecond()).save());
            bankData.add((Object)tag);
        });
        compound.m_128365_("PlayerBankData", (Tag)bankData);
        return compound;
    }

    private static BankAccount loadBankAccount(UUID player, CompoundTag compound) {
        BankAccount bankAccount = new BankAccount(() -> BankSaveData.MarkBankAccountDirty(player), compound);
        try {
            bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(player));
            bankAccount.updateOwnersName(PlayerReference.of(player, bankAccount.getOwnersName()).getName(false));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return bankAccount;
    }

    private static BankAccount generateBankAccount(UUID player) {
        BankAccount bankAccount = new BankAccount(() -> BankSaveData.MarkBankAccountDirty(player));
        try {
            bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(player));
            bankAccount.updateOwnersName(PlayerReference.of(player, bankAccount.getOwnersName()).getName(false));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return bankAccount;
    }

    private static BankSaveData get() {
        ServerLevel level;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (level = server.m_129880_(Level.f_46428_)) != null) {
            return (BankSaveData)level.m_8895_().m_164861_(BankSaveData::new, BankSaveData::new, "lightmanscurrency_bank_data");
        }
        return null;
    }

    public static List<BankReference> GetPlayerBankAccounts() {
        ArrayList<BankReference> results = new ArrayList<BankReference>();
        BankSaveData bsd = BankSaveData.get();
        if (bsd != null) {
            bsd.playerBankData.forEach((player, data) -> results.add(PlayerBankReference.of(player)));
        }
        return results;
    }

    public static BankAccount GetBankAccount(Player player) {
        return BankSaveData.GetBankAccount(player.m_9236_().f_46443_, player.m_20148_());
    }

    public static BankAccount GetBankAccount(boolean isClient, UUID player) {
        if (isClient) {
            return ClientBankData.GetPlayerBankAccount(player);
        }
        BankSaveData bsd = BankSaveData.get();
        if (bsd != null) {
            if (bsd.playerBankData.containsKey(player)) {
                return (BankAccount)bsd.playerBankData.get(player).getFirst();
            }
            BankAccount newAccount = BankSaveData.generateBankAccount(player);
            bsd.playerBankData.put(player, (Pair<BankAccount, BankReference>)Pair.of((Object)newAccount, (Object)PlayerBankReference.of(player)));
            BankSaveData.MarkBankAccountDirty(player);
            return newAccount;
        }
        return null;
    }

    public static void MarkBankAccountDirty(UUID player) {
        BankSaveData bsd = BankSaveData.get();
        if (bsd != null) {
            bsd.m_77762_();
            BankAccount bankAccount = BankSaveData.GetBankAccount(false, player);
            CompoundTag compound = bankAccount.save();
            compound.m_128362_("Player", player);
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientBank(compound));
        }
    }

    public static BankReference GetSelectedBankAccount(Player player) {
        if (player.m_9236_().f_46443_) {
            ClientBankData.GetLastSelectedAccount();
        } else {
            BankSaveData bsd = BankSaveData.get();
            if (bsd != null) {
                if (bsd.playerBankData.containsKey(player.m_20148_())) {
                    BankReference account = (BankReference)bsd.playerBankData.get(player.m_20148_()).getSecond();
                    if (!account.allowedAccess(player)) {
                        LightmansCurrency.LogInfo(player.m_7755_().getString() + " is no longer allowed to access their selected bank account. Switching back to their personal account.");
                        account = PlayerBankReference.of(player);
                        BankSaveData.SetSelectedBankAccount(player, account);
                    }
                    return account;
                }
                BankReference account = PlayerBankReference.of(player);
                BankSaveData.SetSelectedBankAccount(player, account);
                return account;
            }
        }
        return PlayerBankReference.of(player);
    }

    public static void SetSelectedBankAccount(Player player, BankReference account) {
        if (account == null) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSelectBankAccount(account));
        } else {
            if (!account.allowedAccess(player)) {
                LightmansCurrency.LogInfo("Player does not have access to the selected account. Canceling selection.");
                return;
            }
            BankSaveData bsd = BankSaveData.get();
            if (bsd != null) {
                if (bsd.playerBankData.containsKey(player.m_20148_())) {
                    bsd.playerBankData.put(player.m_20148_(), (Pair<BankAccount, BankReference>)Pair.of((Object)((BankAccount)bsd.playerBankData.get(player.m_20148_()).getFirst()), (Object)account));
                } else {
                    bsd.playerBankData.put(player.m_20148_(), (Pair<BankAccount, BankReference>)Pair.of((Object)BankSaveData.generateBankAccount(player.m_20148_()), (Object)account));
                    BankSaveData.MarkBankAccountDirty(player.m_20148_());
                }
                bsd.m_77762_();
                try {
                    LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new SPacketSyncSelectedBankAccount(account));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public static void OnPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getEntity());
        BankSaveData bsd = BankSaveData.get();
        BankSaveData.GetBankAccount(event.getEntity());
        CompoundTag compound = new CompoundTag();
        ListTag bankList = new ListTag();
        bsd.playerBankData.forEach((id, data) -> {
            CompoundTag tag = ((BankAccount)data.getFirst()).save();
            tag.m_128362_("Player", id);
            bankList.add((Object)tag);
        });
        compound.m_128365_("BankAccounts", (Tag)bankList);
        LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageInitializeClientBank(compound));
        BankReference selectedAccount = BankSaveData.GetSelectedBankAccount(event.getEntity());
        LightmansCurrencyPacketHandler.instance.send(target, (Object)new SPacketSyncSelectedBankAccount(selectedAccount));
    }
}

