/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.atm.icons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMExchangeButton;
import io.github.lightman314.lightmanscurrency.common.atm.ATMIconData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemIcon
extends ATMIconData {
    public static final ResourceLocation TYPE_NAME = new ResourceLocation("lightmanscurrency", "item");
    public static final ATMIconData.IconType TYPE = ATMIconData.IconType.create(TYPE_NAME, ItemIcon::new);
    private final boolean simpleItem;
    private final ItemStack item;

    public ItemIcon(JsonObject data) throws RuntimeException {
        super(data);
        JsonElement itemData = data.get("item");
        if (itemData.isJsonPrimitive()) {
            this.item = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemData.getAsString())));
            this.simpleItem = true;
        } else {
            try {
                this.item = FileUtil.parseItemStack(itemData.getAsJsonObject());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.item.m_41764_(1);
            this.simpleItem = false;
        }
    }

    public ItemIcon(int xPos, int yPos, ItemLike item) {
        super(xPos, yPos);
        this.item = new ItemStack(item);
        this.simpleItem = true;
    }

    @Override
    protected void saveAdditional(JsonObject data) {
        if (this.simpleItem) {
            data.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.item.m_41720_()).toString());
        } else {
            data.add("item", (JsonElement)FileUtil.convertItemStack(this.item));
        }
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE_NAME;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(@Nonnull ATMExchangeButton button, @Nonnull EasyGuiGraphics gui, boolean isHovered) {
        gui.renderItem(this.item, this.xPos, this.yPos, "");
    }
}

