/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.events.WalletDropEvent;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessagePlayPickupSound;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void pickupItem(EntityItemPickupEvent event) {
        WalletItem walletItem;
        WalletMenuBase container;
        ItemStack pickupItem = event.getItem().m_32055_();
        CoinData coinData = MoneyUtil.getData(pickupItem.m_41720_());
        if (coinData == null || coinData.isHidden) {
            return;
        }
        Player player = event.getEntity();
        ItemStack coinStack = event.getItem().m_32055_();
        WalletMenuBase activeContainer = null;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof WalletMenuBase && (container = (WalletMenuBase)abstractContainerMenu).isEquippedWallet()) {
            activeContainer = container;
        }
        boolean cancelEvent = false;
        ItemStack wallet = LightmansCurrency.getWalletStack(player);
        if (!wallet.m_41619_() && WalletItem.CanPickup(walletItem = (WalletItem)wallet.m_41720_())) {
            cancelEvent = true;
            coinStack = activeContainer != null ? activeContainer.PickupCoins(coinStack) : WalletItem.PickupCoin(wallet, coinStack);
        }
        if (event.isCancelable() && cancelEvent) {
            event.getItem().m_32045_(ItemStack.f_41583_);
            if (!coinStack.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)coinStack);
            }
            if (!player.m_9236_().f_46443_) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)MessagePlayPickupSound.INSTANCE);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        IOwnableBlock block;
        LevelAccessor level = event.getLevel();
        BlockState state = event.getState();
        Block block2 = state.m_60734_();
        if (block2 instanceof IOwnableBlock && !(block = (IOwnableBlock)block2).canBreak(event.getPlayer(), level, event.getPos(), state)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void blockBreakSpeed(PlayerEvent.BreakSpeed event) {
        Level level = event.getEntity().m_9236_();
        BlockState state = event.getState();
        Block block = event.getState().m_60734_();
        if (block instanceof IOwnableBlock) {
            IOwnableBlock block2 = (IOwnableBlock)block;
            event.getPosition().ifPresent(pos -> {
                if (!block2.canBreak(event.getEntity(), (LevelAccessor)level, (BlockPos)pos, state)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void attachEntitiesCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(CurrencyCapabilities.ID_WALLET, WalletCapability.createProvider(player));
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        EventHandler.sendWalletUpdatePacket((Entity)event.getEntity(), LightmansCurrencyPacketHandler.getTarget(event.getEntity()));
    }

    @SubscribeEvent
    public static void playerStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        EventHandler.sendWalletUpdatePacket(target, LightmansCurrencyPacketHandler.getTarget(player));
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        IWalletHandler oldHandler = WalletCapability.lazyGetWalletHandler((Entity)oldPlayer);
        IWalletHandler newHandler = WalletCapability.lazyGetWalletHandler((Entity)event.getEntity());
        if (oldHandler != null && newHandler != null) {
            newHandler.setWallet(oldHandler.getWallet());
            newHandler.setVisible(oldHandler.visible());
        }
        oldPlayer.invalidateCaps();
    }

    @SubscribeEvent
    public static void playerChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        EventHandler.sendWalletUpdatePacket((Entity)player, LightmansCurrencyPacketHandler.getTarget(player));
    }

    private static void sendWalletUpdatePacket(Entity entity, PacketDistributor.PacketTarget target) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler(entity);
        if (walletHandler != null) {
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new SPacketSyncWallet(entity.m_19879_(), walletHandler.getWallet(), walletHandler.visible()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerDrops(LivingDropsEvent event) {
        IWalletHandler walletHandler;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        if (!livingEntity.m_5833_() && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)livingEntity)) != null) {
            ItemStack walletStack = walletHandler.getWallet();
            if (walletStack.m_41619_()) {
                return;
            }
            Collection<Object> walletDrops = Lists.newArrayList();
            if (livingEntity instanceof Player) {
                boolean keepWallet = ModGameRules.safeGetCustomBool(livingEntity.m_9236_(), ModGameRules.KEEP_WALLET, false);
                if (!LightmansCurrency.isCuriosValid(livingEntity) && livingEntity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                    keepWallet = true;
                }
                int coinDropPercent = ModGameRules.safeGetCustomInt(livingEntity.m_9236_(), ModGameRules.COIN_DROP_PERCENT, 0);
                if (keepWallet && coinDropPercent <= 0) {
                    return;
                }
                if (keepWallet) {
                    List<ItemEntity> d = EventHandler.getWalletDrops(livingEntity, walletStack, coinDropPercent);
                    walletDrops.addAll(d);
                    WalletDropEvent e = new WalletDropEvent((Player)livingEntity, walletHandler, event.getSource(), (Collection<ItemEntity>)walletDrops, keepWallet, coinDropPercent);
                    if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                        return;
                    }
                    walletDrops = e.getDrops();
                } else if (!LightmansCurrency.isCuriosValid(livingEntity)) {
                    walletDrops.add(EventHandler.getDrop(livingEntity, walletStack));
                    walletHandler.setWallet(ItemStack.f_41583_);
                    WalletDropEvent e = new WalletDropEvent((Player)livingEntity, walletHandler, event.getSource(), (Collection<ItemEntity>)walletDrops, keepWallet, coinDropPercent);
                    if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                        return;
                    }
                    walletDrops = e.getDrops();
                }
            } else {
                walletDrops.add(EventHandler.getDrop(livingEntity, walletStack));
                walletHandler.setWallet(ItemStack.f_41583_);
            }
            event.getDrops().addAll(walletDrops);
        }
    }

    private static ItemEntity getDrop(LivingEntity entity, ItemStack stack) {
        return new ItemEntity(entity.m_9236_(), entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, stack);
    }

    private static List<ItemEntity> getWalletDrops(LivingEntity entity, ItemStack walletStack, int coinDropPercent) {
        double coinPercentage = MathUtil.clamp((double)coinDropPercent / 100.0, 0.0, 1.0);
        NonNullList<ItemStack> walletList = WalletItem.getWalletInventory(walletStack);
        long walletContents = MoneyUtil.getValue(walletList);
        long droppedAmount = (long)((double)walletContents * coinPercentage);
        if (droppedAmount < 1L) {
            return Lists.newArrayList();
        }
        SimpleContainer walletInventory = InventoryUtil.buildInventory(walletList);
        ArrayList drops = Lists.newArrayList();
        long extra = MoneyUtil.takeObjectsOfValue(droppedAmount, (Container)walletInventory, true);
        if (extra < 0L) {
            List<ItemStack> extraCoins = MoneyUtil.getCoinsOfValue(-extra);
            for (ItemStack extraCoin : extraCoins) {
                ItemStack coinStack = InventoryUtil.TryPutItemStack((Container)walletInventory, extraCoin);
                if (coinStack.m_41619_()) continue;
                drops.add(EventHandler.getDrop(entity, coinStack));
            }
        }
        WalletItem.putWalletInventory(walletStack, InventoryUtil.buildList((Container)walletInventory));
        drops.addAll(EventHandler.getCoinDrops(entity, droppedAmount));
        return drops;
    }

    private static Collection<ItemEntity> getCoinDrops(LivingEntity entity, long coinValue) {
        ArrayList drops = Lists.newArrayList();
        List<ItemStack> coinsOfValue = MoneyUtil.getCoinsOfValue(coinValue);
        for (ItemStack coinStack : coinsOfValue) {
            for (int count = 0; count < coinStack.m_41613_(); ++count) {
                ItemStack coin = coinStack.m_41777_();
                coin.m_41764_(1);
                drops.add(EventHandler.getDrop(entity, coin));
            }
        }
        return drops;
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)livingEntity);
        if (walletHandler != null) {
            walletHandler.tick();
            if (walletHandler.isDirty()) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), (Object)new SPacketSyncWallet(livingEntity.m_19879_(), walletHandler.getWallet(), walletHandler.visible()));
                walletHandler.clean();
            }
        }
    }
}

