/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.common.easy.IEasyTickable;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.NumberUtil;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;

public class TextInputUtil {
    private static final String INTEGER_WHITELIST = "0123456789";
    private static final String FLOAT_WHITELIST = "0123456789.";

    public static int getIntegerValue(EditBox textInput) {
        return TextInputUtil.getIntegerValue(textInput, 0);
    }

    public static int getIntegerValue(EditBox textInput, int defaultValue) {
        return NumberUtil.GetIntegerValue(textInput.m_94155_(), defaultValue);
    }

    public static boolean isLong(EditBox textInput) {
        return TextInputUtil.isLong(textInput.m_94155_());
    }

    public static boolean isLong(String text) {
        if (text == null) {
            return false;
        }
        try {
            long l = Long.parseLong(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static long getLongValue(EditBox textInput) {
        return TextInputUtil.getLongValue(textInput, 0);
    }

    public static long getLongValue(EditBox textInput, int defaultValue) {
        if (TextInputUtil.isLong(textInput)) {
            return Long.parseLong(textInput.m_94155_());
        }
        return defaultValue;
    }

    public static boolean isFloat(EditBox textInput) {
        return TextInputUtil.isFloat(textInput.m_94155_());
    }

    public static boolean isFloat(String text) {
        if (text == null) {
            return false;
        }
        try {
            float f = Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static float getFloatValue(EditBox textInput) {
        return TextInputUtil.getFloatValue(textInput, 0.0f);
    }

    public static float getFloatValue(EditBox textInput, float defaultValue) {
        if (TextInputUtil.isFloat(textInput)) {
            return Float.parseFloat(textInput.m_94155_());
        }
        return defaultValue;
    }

    public static boolean isDouble(EditBox textInput) {
        return TextInputUtil.isDouble(textInput.m_94155_());
    }

    public static boolean isDouble(String text) {
        if (text == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static double getDoubleValue(EditBox textInput) {
        return TextInputUtil.getDoubleValue(textInput, 0.0);
    }

    public static double getDoubleValue(EditBox textInput, double defaultValue) {
        if (TextInputUtil.isDouble(textInput)) {
            return Double.parseDouble(textInput.m_94155_());
        }
        return defaultValue;
    }

    public static void whitelistInteger(EditBox textInput) {
        TextInputUtil.whitelistText(textInput, INTEGER_WHITELIST);
    }

    public static void whitelistInteger(EditBox textInput, long minValue, long maxValue) {
        long currentValue;
        TextInputUtil.whitelistInteger(textInput);
        if (textInput.m_94155_().length() > 0 && ((currentValue = TextInputUtil.getLongValue(textInput)) < minValue || currentValue > maxValue)) {
            currentValue = MathUtil.clamp(currentValue, minValue, maxValue);
            textInput.m_94144_(Long.toString(currentValue));
        }
    }

    public static void whitelistFloat(EditBox textInput) {
        TextInputUtil.whitelistText(textInput, FLOAT_WHITELIST);
    }

    public static void whitelistText(EditBox textInput, String allowedChars) {
        StringBuilder newText = new StringBuilder(textInput.m_94155_());
        for (int i = 0; i < newText.length(); ++i) {
            boolean allowed = false;
            for (int x = 0; x < allowedChars.length() && !allowed; ++x) {
                if (allowedChars.charAt(x) != newText.charAt(i)) continue;
                allowed = true;
            }
            if (allowed) continue;
            newText.deleteCharAt(i--);
        }
        textInput.m_94144_(newText.toString());
    }

    public static Object CreateInputHandler(@Nonnull EditBox editBox, int startingValue, int minValue, int maxValue, @Nonnull Consumer<Integer> onValueChange) {
        return new IntegerInputHandler(editBox, startingValue, minValue, maxValue, onValueChange);
    }

    private static class IntegerInputHandler
    implements IEasyTickable {
        private final EditBox editBox;
        private final int minValue;
        private final int maxValue;
        private final Consumer<Integer> onValueChange;
        private int lastValue;

        IntegerInputHandler(@Nonnull EditBox editBox, int startingValue, int minValue, int maxValue, @Nonnull Consumer<Integer> onValueChange) {
            this.editBox = editBox;
            this.lastValue = startingValue;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.onValueChange = onValueChange;
            this.editBox.m_94144_(Integer.toString(this.lastValue));
        }

        @Override
        public void tick() {
            TextInputUtil.whitelistInteger(this.editBox, this.minValue, this.maxValue);
            int newVal = MathUtil.clamp(TextInputUtil.getIntegerValue(this.editBox), this.minValue, this.maxValue);
            if (this.lastValue != newVal) {
                this.onValueChange.accept(newVal);
                this.lastValue = newVal;
            }
        }
    }
}

