/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.lightman314.lightmanscurrency.client.util.LCRenderTypes;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class OutlineUtil {
    public static Vector4f decodeColor(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector4f(r, g, b, alpha);
    }

    public static Vector4f decodeColor(int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        return new Vector4f(r, g, b, a);
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, int color) {
        OutlineUtil.renderBox(pose, buffer, area, OutlineUtil.decodeColor(color));
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, int color, float alpha) {
        OutlineUtil.renderBox(pose, buffer, area, OutlineUtil.decodeColor(color, alpha));
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, Vector4f color) {
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float inflate = 0.015625f;
        if (area.m_82390_(camera)) {
            inflate *= -1.0f;
        }
        Vector3f minPos = new Vector3f((float)area.f_82288_ - inflate, (float)area.f_82289_ - inflate, (float)area.f_82290_ - inflate);
        Vector3f maxPos = new Vector3f((float)area.f_82291_ + inflate, (float)area.f_82292_ + inflate, (float)area.f_82293_ + inflate);
        OutlineUtil.renderBoxFaces(pose, buffer, minPos, maxPos, color);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110504_());
        LevelRenderer.m_109608_((PoseStack)pose, (VertexConsumer)consumer, (double)minPos.x(), (double)minPos.y(), (double)minPos.z(), (double)maxPos.x(), (double)maxPos.y(), (double)maxPos.z(), (float)color.x(), (float)color.y(), (float)color.z(), (float)1.0f);
    }

    private static void renderBoxFaces(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, Vector3f minPos, Vector3f maxPos, Vector4f color) {
        PoseStack.Pose pose = poseStack.m_85850_();
        VertexConsumer consumer = buffer.m_6299_(LCRenderTypes.getOutlineTranslucent());
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.DOWN, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.UP, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.NORTH, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.SOUTH, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.EAST, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.WEST, color);
    }

    private static void renderBoxFace(@Nonnull PoseStack.Pose pose, @Nonnull VertexConsumer consumer, Vector3f minPos, Vector3f maxPos, Direction face, Vector4f color) {
        Vector3f pos0 = new Vector3f();
        Vector3f pos1 = new Vector3f();
        Vector3f pos2 = new Vector3f();
        Vector3f pos3 = new Vector3f();
        Vector3f normal = new Vector3f();
        float minX = minPos.x();
        float minY = minPos.y();
        float minZ = minPos.z();
        float maxX = maxPos.x();
        float maxY = maxPos.y();
        float maxZ = maxPos.z();
        switch (face) {
            case DOWN: {
                pos0.set(maxX, minY, minZ);
                pos1.set(maxX, minY, maxZ);
                pos2.set(minX, minY, maxZ);
                pos3.set(minX, minY, minZ);
                normal.set(0.0f, -1.0f, 0.0f);
                break;
            }
            case UP: {
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, maxY, maxZ);
                pos2.set(maxX, maxY, maxZ);
                pos3.set(maxX, maxY, minZ);
                normal.set(0.0f, 1.0f, 0.0f);
                break;
            }
            case NORTH: {
                pos0.set(maxX, maxY, minZ);
                pos1.set(maxX, minY, minZ);
                pos2.set(minX, minY, minZ);
                pos3.set(minX, maxY, minZ);
                normal.set(0.0f, 0.0f, -1.0f);
                break;
            }
            case SOUTH: {
                pos0.set(minX, maxY, maxZ);
                pos1.set(minX, minY, maxZ);
                pos2.set(maxX, minY, maxZ);
                pos3.set(maxX, maxY, maxZ);
                normal.set(0.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, minY, minZ);
                pos2.set(minX, minY, maxZ);
                pos3.set(minX, maxY, maxZ);
                normal.set(-1.0f, 0.0f, 0.0f);
                break;
            }
            case EAST: {
                pos0.set(maxX, maxY, maxZ);
                pos1.set(maxX, minY, maxZ);
                pos2.set(maxX, minY, minZ);
                pos3.set(maxX, maxY, minZ);
                normal.set(1.0f, 0.0f, 0.0f);
            }
        }
        Matrix4f posMatrix = pose.m_252922_();
        Vector4f posTransformTemp = new Vector4f(pos0.x(), pos0.y(), pos0.z(), 1.0f);
        posTransformTemp.set(pos0.x(), pos0.y(), pos0.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        double x0 = posTransformTemp.x();
        double y0 = posTransformTemp.y();
        double z0 = posTransformTemp.z();
        posTransformTemp.set(pos1.x(), pos1.y(), pos1.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        double x1 = posTransformTemp.x();
        double y1 = posTransformTemp.y();
        double z1 = posTransformTemp.z();
        posTransformTemp.set(pos2.x(), pos2.y(), pos2.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        double x2 = posTransformTemp.x();
        double y2 = posTransformTemp.y();
        double z2 = posTransformTemp.z();
        posTransformTemp.set(pos3.x(), pos3.y(), pos3.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        double x3 = posTransformTemp.x();
        double y3 = posTransformTemp.y();
        double z3 = posTransformTemp.z();
        float r = color.x();
        float g = color.y();
        float b = color.z();
        float a = color.w();
        Vector3f normalTransformTemp = new Vector3f();
        normalTransformTemp.set((Vector3fc)normal);
        normalTransformTemp.mul((Matrix3fc)pose.m_252943_());
        float nx = normalTransformTemp.x();
        float ny = normalTransformTemp.y();
        float nz = normalTransformTemp.z();
        consumer.m_5483_(x0, y0, z0).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x1, y1, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 2.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x2, y2, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x3, y3, z3).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(nx, ny, nz).m_5752_();
    }
}

