/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ItemTraderBlockEntityRenderer
implements BlockEntityRenderer<ItemTraderBlockEntity> {
    private static long rotationTime = 0L;

    public ItemTraderBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull ItemTraderBlockEntity blockEntity, float partialTicks, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(blockEntity, partialTicks, pose, buffer, lightLevel, id);
    }

    public static List<ItemStack> GetRenderItems(ItemTradeData trade) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = trade.getSellItem(i);
            if (item.m_41619_()) continue;
            result.add(item);
        }
        return result;
    }

    public static void renderItems(ItemTraderBlockEntity blockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int lightLevel, int id) {
        try {
            TraderData rawTrader = blockEntity.getRawTraderData();
            if (!(rawTrader instanceof ItemTraderData)) {
                return;
            }
            ItemTraderData trader = (ItemTraderData)rawTrader;
            for (int tradeSlot = 0; tradeSlot < trader.getTradeCount() && tradeSlot < blockEntity.maxRenderIndex(); ++tradeSlot) {
                ItemTradeData trade = trader.getTrade(tradeSlot);
                List<ItemStack> renderItems = ItemTraderBlockEntityRenderer.GetRenderItems(trade);
                if (renderItems.size() <= 0) continue;
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                List<Vector3f> positions = blockEntity.GetStackRenderPos(tradeSlot, renderItems.size() > 1);
                List<Quaternionf> rotation = blockEntity.GetStackRenderRot(tradeSlot, partialTicks);
                float scale = blockEntity.GetStackRenderScale(tradeSlot);
                for (int pos = 0; pos < (Integer)Config.CLIENT.itemRenderLimit.get() && pos < positions.size() && pos < trader.getTradeStock(tradeSlot); ++pos) {
                    pose.m_85836_();
                    Vector3f position = positions.get(pos);
                    pose.m_252880_(position.x(), position.y(), position.z());
                    for (Quaternionf rot : rotation) {
                        pose.m_252781_(rot);
                    }
                    pose.m_85841_(scale, scale, scale);
                    if (renderItems.size() > 1) {
                        pose.m_85836_();
                        pose.m_85837_(0.25, 0.25, 0.0);
                        pose.m_85841_(0.5f, 0.5f, 0.5f);
                        itemRenderer.m_269128_(renderItems.get(0), ItemDisplayContext.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, blockEntity.m_58904_(), id);
                        pose.m_85849_();
                        pose.m_85836_();
                        pose.m_85837_(-0.25, -0.25, 0.001);
                        pose.m_85841_(0.5f, 0.5f, 0.5f);
                        itemRenderer.m_269128_(renderItems.get(1), ItemDisplayContext.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, blockEntity.m_58904_(), id);
                        pose.m_85849_();
                    } else {
                        itemRenderer.m_269128_(renderItems.get(0), ItemDisplayContext.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, blockEntity.m_58904_(), id);
                    }
                    pose.m_85849_();
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering an Item Trader!", t);
        }
    }

    public static long getRotationTime() {
        return rotationTime;
    }

    public static Quaternionf getRotation(float partialTicks) {
        return new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), ((float)ItemTraderBlockEntityRenderer.getRotationTime() + partialTicks) * 2.0f);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++rotationTime;
        }
    }
}

