/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinChestBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CoinChestRenderer
implements BlockEntityRenderer<CoinChestBlockEntity> {
    public static final Material COIN_CHEST_MATERIAL = new Material(Sheets.f_110740_, new ResourceLocation("lightmanscurrency", "entity/chest/coin_chest"));
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;

    public CoinChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_("bottom");
        this.lid = modelpart.m_171324_("lid");
        this.lock = modelpart.m_171324_("lock");
    }

    public void render(@Nonnull CoinChestBlockEntity blockEntity, float partialTicks, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int lightLevel, int id) {
        Level level = blockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.m_58900_() : (BlockState)((Block)ModBlocks.COIN_CHEST.get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.NORTH);
        Block block = blockstate.m_60734_();
        if (block instanceof CoinChestBlock) {
            CoinChestBlock abstractchestblock = (CoinChestBlock)block;
            pose.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122424_().m_122435_();
            pose.m_252880_(0.5f, 0.5f, 0.5f);
            pose.m_252781_(Axis.f_252436_.m_252977_(-f));
            pose.m_252880_(-0.5f, -0.5f, -0.5f);
            float f1 = blockEntity.m_6683_(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            VertexConsumer vertexconsumer = COIN_CHEST_MATERIAL.m_119194_(buffer, RenderType::m_110452_);
            this.render(pose, vertexconsumer, this.lid, this.lock, this.bottom, f1, lightLevel, id);
            pose.m_85849_();
        }
    }

    private void render(PoseStack pose, VertexConsumer vertex, ModelPart lid, ModelPart lock, ModelPart bottom, float lidAngle, int lightLevel, int id) {
        lock.f_104203_ = lid.f_104203_ = -(lidAngle * 1.5707964f);
        lid.m_104301_(pose, vertex, lightLevel, id);
        lock.m_104301_(pose, vertex, lightLevel, id);
        bottom.m_104301_(pose, vertex, lightLevel, id);
    }
}

