/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.notifications;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;

public class NotificationDisplayWidget
extends EasyWidget
implements IScrollable,
ITooltipWidget {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/notifications.png");
    public static final int HEIGHT_PER_ROW = 22;
    private final NonNullSupplier<List<Notification>> notificationSource;
    private final int rowCount;
    public boolean colorIfUnseen = false;
    public int backgroundColor = -3750202;
    Component tooltip = null;
    private int scroll = 0;

    public static int CalculateHeight(int rowCount) {
        return rowCount * 22;
    }

    private List<Notification> getNotifications() {
        return (List)this.notificationSource.get();
    }

    public NotificationDisplayWidget(ScreenPosition pos, int width, int rowCount, NonNullSupplier<List<Notification>> notificationSource) {
        this(pos.x, pos.y, width, rowCount, notificationSource);
    }

    public NotificationDisplayWidget(int x, int y, int width, int rowCount, NonNullSupplier<List<Notification>> notificationSource) {
        super(x, y, width, NotificationDisplayWidget.CalculateHeight(rowCount));
        this.notificationSource = notificationSource;
        this.rowCount = rowCount;
    }

    @Override
    public NotificationDisplayWidget withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    @Override
    public void renderWidget(@NotNull EasyGuiGraphics gui) {
        this.validateScroll();
        this.tooltip = null;
        List<Notification> notifications = this.getNotifications();
        int index = this.scroll;
        gui.fill(0, 0, this.f_93618_, this.f_93619_, this.backgroundColor);
        for (int y = 0; y < this.rowCount && index < notifications.size(); ++y) {
            MutableComponent message;
            List lines;
            int textColor;
            int thisWidth;
            int yPos = y * 22;
            Notification n = notifications.get(index++);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
            gui.resetColor();
            int vPos = n.wasSeen() && this.colorIfUnseen ? 222 : 200;
            gui.blit(GUI_TEXTURE, 0, yPos, 0, vPos, 2, 22);
            for (int xPos = 2; xPos < this.f_93618_ - 2; xPos += thisWidth) {
                thisWidth = Math.min(166, this.f_93618_ - 2 - xPos);
                gui.blit(GUI_TEXTURE, xPos, yPos, 2, vPos, thisWidth, 22);
            }
            gui.blit(GUI_TEXTURE, this.f_93618_ - 2, yPos, 168, 200, 2, 22);
            int textXPos = 2;
            int textWidth = this.f_93618_ - 4;
            int n2 = textColor = n.wasSeen() ? 0xFFFFFF : 0;
            if (n.getCount() > 1) {
                String countText = String.valueOf(n.getCount());
                int quantityWidth = gui.font.m_92895_(countText);
                gui.blit(GUI_TEXTURE, 1 + quantityWidth, yPos, 170, vPos, 3, 22);
                Objects.requireNonNull(gui.font);
                gui.drawString(countText, textXPos, yPos + 11 - 9 / 2, textColor);
                textXPos += quantityWidth + 2;
                textWidth -= quantityWidth + 2;
            }
            if ((lines = gui.font.m_92923_((FormattedText)(message = n.getMessage()), textWidth)).size() == 1) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(0);
                Objects.requireNonNull(gui.font);
                gui.drawString(formattedCharSequence, textXPos, yPos + 11 - 9 / 2, textColor);
                continue;
            }
            for (int l = 0; l < lines.size() && l < 2; ++l) {
                gui.drawString((FormattedCharSequence)lines.get(l), textXPos, yPos + 2 + l * 10, textColor);
            }
            if (this.tooltip != null || gui.mousePos.x < this.m_252754_() || gui.mousePos.x >= this.m_252754_() + this.f_93618_ || gui.mousePos.y < yPos || gui.mousePos.y >= yPos + 22) continue;
            if (lines.size() > 2) {
                if (n.hasTimeStamp()) {
                    this.tooltip = Component.m_237119_().m_7220_(n.getTimeStampMessage()).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)message);
                    continue;
                }
                this.tooltip = message;
                continue;
            }
            if (!n.hasTimeStamp()) continue;
            this.tooltip = n.getTimeStampMessage();
        }
    }

    @Override
    public List<Component> getTooltipText() {
        if (this.tooltip != null) {
            return ImmutableList.of((Object)this.tooltip);
        }
        return null;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.getNotifications().size() - this.rowCount);
    }

    @Override
    protected void m_168797_(@NotNull NarrationElementOutput narrator) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        this.handleScrollWheel(scroll);
        return true;
    }

    @Override
    public void m_7435_(@NotNull SoundManager manager) {
    }
}

