/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DropdownWidget
extends EasyWidgetWithChildren
implements IMouseListener {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/dropdown.png");
    public static final int HEIGHT = 12;
    boolean open = false;
    int currentlySelected;
    private final List<Component> options;
    private final Consumer<Integer> onSelect;
    private final Function<Integer, Boolean> optionActive;
    List<EasyButton> optionButtons = new ArrayList<EasyButton>();

    public DropdownWidget(ScreenPosition pos, int width, int selected, Consumer<Integer> onSelect, Component ... options) {
        this(pos.x, pos.y, width, selected, onSelect, options);
    }

    public DropdownWidget(int x, int y, int width, int selected, Consumer<Integer> onSelect, Component ... options) {
        this(x, y, width, selected, onSelect, (Integer index) -> true, options);
    }

    public DropdownWidget(ScreenPosition pos, int width, int selected, Consumer<Integer> onSelect, List<Component> options) {
        this(pos.x, pos.y, width, selected, onSelect, options);
    }

    public DropdownWidget(int x, int y, int width, int selected, Consumer<Integer> onSelect, List<Component> options) {
        this(x, y, width, selected, onSelect, (Integer index) -> true, options);
    }

    public DropdownWidget(ScreenPosition pos, int width, int selected, Consumer<Integer> onSelect, Function<Integer, Boolean> optionActive, Component ... options) {
        this(pos.x, pos.y, width, selected, onSelect, optionActive, options);
    }

    public DropdownWidget(int x, int y, int width, int selected, Consumer<Integer> onSelect, Function<Integer, Boolean> optionActive, Component ... options) {
        this(x, y, width, selected, onSelect, optionActive, Lists.newArrayList((Object[])options));
    }

    public DropdownWidget(ScreenPosition pos, int width, int selected, Consumer<Integer> onSelect, Function<Integer, Boolean> optionActive, List<Component> options) {
        this(pos.x, pos.y, width, selected, onSelect, optionActive, options);
    }

    public DropdownWidget(int x, int y, int width, int selected, Consumer<Integer> onSelect, Function<Integer, Boolean> optionActive, List<Component> options) {
        super(x, y, width, 12);
        this.options = options;
        this.currentlySelected = MathUtil.clamp(selected, 0, this.options.size() - 1);
        this.onSelect = onSelect;
        this.optionActive = optionActive;
    }

    @Override
    public DropdownWidget withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    @Override
    public boolean addChildrenBeforeThis() {
        return true;
    }

    @Override
    public void addChildren() {
        this.optionButtons = new ArrayList<EasyButton>();
        for (int i = 0; i < this.options.size(); ++i) {
            int yPos = this.m_252907_() + 12 + i * 12;
            DropdownButton button = this.addChild(new DropdownButton(this.m_252754_(), yPos, this.f_93618_, this.options.get(i), this::OnSelect));
            this.optionButtons.add(button);
            this.optionButtons.get((int)i).f_93624_ = this.open;
        }
    }

    @Override
    public void renderTick() {
        if (this.open) {
            for (int i = 0; i < this.optionButtons.size(); ++i) {
                this.optionButtons.get((int)i).f_93623_ = this.optionActive.apply(i) != false && i != this.currentlySelected;
            }
        }
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        int xPart;
        int offset;
        int n = offset = this.f_93622_ ? this.f_93619_ : 0;
        if (!this.f_93623_) {
            gui.setColor(0.5f, 0.5f, 0.5f);
        } else {
            gui.resetColor();
        }
        gui.blit(GUI_TEXTURE, 0, 0, 0, offset, 2, 12);
        for (int xOffset = 0; xOffset < this.f_93618_ - 14; xOffset += xPart) {
            xPart = Math.min(this.f_93618_ - 14 - xOffset, 244);
            gui.blit(GUI_TEXTURE, 2 + xOffset, 0, 2, offset, xPart, 12);
        }
        gui.blit(GUI_TEXTURE, this.f_93618_ - 12, 0, 244, offset, 12, 12);
        gui.drawString(this.fitString(gui, this.options.get(this.currentlySelected).getString()), 2, 2, 0x404040);
        gui.resetColor();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int click) {
        if (this.f_93623_ && this.f_93624_) {
            if (this.m_93680_(mouseX, mouseY) && this.m_7972_(click)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.open = !this.open;
                this.optionButtons.forEach(button -> {
                    button.f_93624_ = this.open;
                });
                return true;
            }
            if (this.open && !this.isOverChild(mouseX, mouseY)) {
                this.open = false;
                this.optionButtons.forEach(button -> {
                    button.f_93624_ = false;
                });
            }
        }
        return false;
    }

    private boolean isOverChild(double mouseX, double mouseY) {
        for (EasyButton b : this.optionButtons) {
            if (!b.m_5953_(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    private void OnSelect(EasyButton button) {
        int index = this.optionButtons.indexOf((Object)button);
        if (index < 0) {
            return;
        }
        this.currentlySelected = index;
        this.onSelect.accept(index);
        this.open = false;
        this.optionButtons.forEach(b -> {
            b.f_93624_ = false;
        });
    }

    @Override
    protected void m_168797_(@NotNull NarrationElementOutput narrator) {
    }

    private String fitString(EasyGuiGraphics gui, String text) {
        if (gui.font.m_92895_(text) <= this.f_93618_ - 14) {
            return text;
        }
        while (gui.font.m_92895_(text + "...") > this.f_93618_ - 14 && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        return text + "...";
    }

    @Override
    protected boolean m_7972_(int button) {
        return button == 0;
    }

    @Override
    public void m_7435_(@Nonnull SoundManager manager) {
        EasyButton.playClick(manager);
    }
}

