/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;

public class TradeButton
extends EasyButton
implements ITooltipSource {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/trade.png");
    public static final int ARROW_WIDTH = 22;
    public static final int ARROW_HEIGHT = 18;
    public static final int TEMPLATE_WIDTH = 212;
    public static final int BUTTON_HEIGHT = 18;
    private final Supplier<TradeData> tradeSource;
    private final Supplier<TradeContext> contextSource;
    public boolean displayOnly = false;

    public TradeData getTrade() {
        return this.tradeSource.get();
    }

    public TradeRenderManager<?> getTradeRenderer() {
        TradeData trade = this.getTrade();
        if (trade != null) {
            return trade.getButtonRenderer();
        }
        return null;
    }

    public TradeContext getContext() {
        return this.contextSource.get();
    }

    public TradeButton(@Nonnull Supplier<TradeContext> contextSource, @Nonnull Supplier<TradeData> tradeSource, Consumer<EasyButton> press) {
        super(0, 0, 0, 18, press);
        this.tradeSource = tradeSource;
        this.contextSource = contextSource;
        this.recalculateSize();
    }

    @Override
    public TradeButton withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    private void recalculateSize() {
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr != null) {
            TradeContext context = this.getContext();
            this.m_93674_(tr.tradeButtonWidth(context));
        }
    }

    @Deprecated
    public void move(int x, int y) {
        this.m_264152_(x, y);
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr == null) {
            return;
        }
        TradeContext context = this.getContext();
        this.recalculateSize();
        this.renderBackground(gui, !context.isStorageMode && !this.displayOnly && this.f_93622_);
        LazyOptional<ScreenPosition> arrowPosOptional = tr.arrowPosition(context);
        arrowPosOptional.ifPresent(arrowPos -> this.renderArrow(gui, (ScreenPosition)arrowPos, !context.isStorageMode && !this.displayOnly && this.f_93622_));
        try {
            tr.renderAdditional(this, gui, context);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error on additional Trade Button rendering.", e);
        }
        this.renderAlert(gui, tr.alertPosition(context), tr.getAlertData(context));
        this.renderDisplays(gui, tr, context);
        gui.resetColor();
    }

    private void renderBackground(@Nonnull EasyGuiGraphics gui, boolean isHovered) {
        int xRend;
        if (this.f_93618_ < 8) {
            LightmansCurrency.LogError("Cannot render a trade button that is less than 8 pixels wide!");
            return;
        }
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        int vOffset = isHovered ? 18 : 0;
        gui.blit(GUI_TEXTURE, 0, 0, 0, vOffset, 4, 18);
        for (int xOff = 4; xOff < this.f_93618_ - 4; xOff += xRend) {
            xRend = Math.min(this.f_93618_ - 4 - xOff, 204);
            gui.blit(GUI_TEXTURE, xOff, 0, 4, vOffset, xRend, 18);
        }
        gui.blit(GUI_TEXTURE, this.f_93618_ - 4, 0, 208, vOffset, 4, 18);
    }

    private void renderArrow(@Nonnull EasyGuiGraphics gui, @Nonnull ScreenPosition position, boolean isHovered) {
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        int vOffset = isHovered ? 18 : 0;
        gui.blit(GUI_TEXTURE, position, 212, vOffset, 22, 18);
    }

    private void renderAlert(@Nonnull EasyGuiGraphics gui, @Nonnull ScreenPosition position, @Nullable List<AlertData> alerts) {
        if (alerts == null || alerts.size() == 0) {
            return;
        }
        alerts.sort(AlertData::compare);
        alerts.get(0).setShaderColor(gui, this.f_93623_ ? 1.0f : 0.5f);
        gui.blit(GUI_TEXTURE, position, 234, 0, 22, 18);
    }

    public void renderDisplays(EasyGuiGraphics gui, TradeRenderManager<?> tr, TradeContext context) {
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(tr, context)) {
            ((DisplayEntry)display.getFirst()).render(gui, 0, 0, (DisplayData)display.getSecond());
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(tr, context)) {
            ((DisplayEntry)display.getFirst()).render(gui, 0, 0, (DisplayData)display.getSecond());
        }
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        List<AlertData> alerts;
        if (!this.m_5953_(mouseX, mouseY)) {
            return null;
        }
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr == null) {
            return null;
        }
        TradeContext context = this.getContext();
        ArrayList<Component> tooltips = new ArrayList<Component>();
        this.tryAddTooltip(tooltips, tr.getAdditionalTooltips(context, mouseX - this.m_252754_(), mouseY - this.m_252907_()));
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(tr, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.m_252754_(), this.m_252907_(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            this.tryAddTooltip(tooltips, ((DisplayEntry)display.getFirst()).tooltip);
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(tr, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.m_252754_(), this.m_252907_(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            this.tryAddTooltip(tooltips, ((DisplayEntry)display.getFirst()).tooltip);
        }
        if (this.isMouseOverAlert(mouseX, mouseY, tr, context) && (alerts = tr.getAlertData(context)) != null && alerts.size() > 0) {
            this.tryAddAlertTooltips(tooltips, alerts);
        }
        if (tooltips.size() == 0) {
            return null;
        }
        return tooltips;
    }

    private void tryAddTooltip(@Nonnull List<Component> tooltips, @Nullable List<Component> add) {
        if (add == null) {
            return;
        }
        tooltips.addAll(add);
    }

    private void tryAddAlertTooltips(@Nonnull List<Component> tooltips, @Nullable List<AlertData> alerts) {
        if (alerts == null) {
            return;
        }
        alerts.sort(AlertData::compare);
        for (AlertData alert : alerts) {
            tooltips.add((Component)alert.getFormattedMessage());
        }
    }

    public void onInteractionClick(int mouseX, int mouseY, int button, TradeButtonArea.InteractionConsumer consumer) {
        if (!this.f_93624_ || !this.m_5953_(mouseX, mouseY)) {
            return;
        }
        TradeData trade = this.getTrade();
        if (trade == null) {
            return;
        }
        TradeRenderManager<?> tr = trade.getButtonRenderer();
        if (tr == null) {
            return;
        }
        TradeContext context = this.getContext();
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(tr, context);
        for (int i = 0; i < inputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = inputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.m_252754_(), this.m_252907_(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            consumer.onTradeButtonInputInteraction(context.getTrader(), trade, i, button);
            return;
        }
        List<Pair<DisplayEntry, DisplayData>> outputDisplays = TradeButton.getOutputDisplayData(tr, context);
        for (int i = 0; i < outputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = outputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.m_252754_(), this.m_252907_(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            consumer.onTradeButtonOutputInteraction(context.getTrader(), trade, i, button);
            return;
        }
        consumer.onTradeButtonInteraction(context.getTrader(), trade, mouseX - this.m_252754_(), mouseY - this.m_252907_(), button);
    }

    public boolean isMouseOverAlert(int mouseX, int mouseY, TradeRenderManager<?> tr, TradeContext context) {
        ScreenPosition position = tr.alertPosition(context);
        int left = this.m_252754_() + position.x;
        int top = this.m_252907_() + position.y;
        return mouseX >= left && mouseX < left + 22 && mouseY >= top && mouseY < top + 18;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getInputDisplayData(TradeRenderManager<?> tr, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = tr.getInputDisplays(context);
        List<DisplayData> display = tr.inputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getOutputDisplayData(TradeRenderManager<?> tr, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = tr.getOutputDisplays(context);
        List<DisplayData> display = tr.outputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    @Override
    protected boolean m_7972_(int button) {
        if (this.getContext().isStorageMode || this.displayOnly) {
            return false;
        }
        return super.m_7972_(button);
    }

    public static abstract class DisplayEntry {
        private final List<Component> tooltip;

        @Deprecated
        protected DisplayEntry() {
            this.tooltip = null;
        }

        protected DisplayEntry(List<Component> tooltip) {
            this.tooltip = tooltip;
        }

        protected final Font getFont() {
            Minecraft m = Minecraft.m_91087_();
            return m.f_91062_;
        }

        protected List<Component> getTooltip() {
            if (this.tooltip == null) {
                return new ArrayList<Component>();
            }
            return this.tooltip;
        }

        public abstract void render(EasyGuiGraphics var1, int var2, int var3, DisplayData var4);

        public abstract boolean isMouseOver(int var1, int var2, DisplayData var3, int var4, int var5);

        public static DisplayEntry of(ItemStack item, int count) {
            return new ItemEntry(item, count, null);
        }

        public static DisplayEntry of(ItemStack item, int count, List<Component> tooltip) {
            return new ItemEntry(item, count, tooltip);
        }

        public static DisplayEntry of(ItemStack item, int count, List<Component> tooltip, Pair<ResourceLocation, ResourceLocation> background) {
            return new ItemAndBackgroundEntry(item, count, tooltip, background, ScreenPosition.ZERO);
        }

        public static DisplayEntry of(ItemStack item, int count, List<Component> tooltip, Pair<ResourceLocation, ResourceLocation> background, ScreenPosition backgroundOffset) {
            return new ItemAndBackgroundEntry(item, count, tooltip, background, backgroundOffset);
        }

        public static DisplayEntry of(Pair<ResourceLocation, ResourceLocation> background) {
            return new EmptySlotEntry(background, null);
        }

        public static DisplayEntry of(Pair<ResourceLocation, ResourceLocation> background, List<Component> tooltip) {
            return new EmptySlotEntry(background, tooltip);
        }

        public static DisplayEntry of(Component text, TextRenderUtil.TextFormatting format) {
            return new TextEntry(text, format, null);
        }

        public static DisplayEntry of(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip) {
            return new TextEntry(text, format, tooltip);
        }

        public static DisplayEntry of(CoinValue price) {
            return new PriceEntry(price, null, false);
        }

        public static DisplayEntry of(CoinValue price, List<Component> additionalTooltips) {
            return new PriceEntry(price, additionalTooltips, false);
        }

        public static DisplayEntry of(CoinValue price, List<Component> additionalTooltips, boolean tooltipOverride) {
            return new PriceEntry(price, additionalTooltips, tooltipOverride);
        }

        private static class ItemEntry
        extends DisplayEntry {
            private final ItemStack item;

            private ItemEntry(ItemStack item, int count, List<Component> tooltip) {
                super(tooltip);
                this.item = item.m_41777_();
                this.item.m_41764_(count);
            }

            private int getTopLeft(int xOrY, int availableWidthOrHeight) {
                return xOrY + availableWidthOrHeight / 2 - 8;
            }

            @Override
            public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
                if (this.item.m_41619_()) {
                    return;
                }
                gui.resetColor();
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                gui.renderItem(this.item, left, top);
            }

            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
            }
        }

        private static class ItemAndBackgroundEntry
        extends DisplayEntry {
            private final ItemStack item;
            private final Pair<ResourceLocation, ResourceLocation> background;
            private final ScreenPosition backgroundOffset;

            private ItemAndBackgroundEntry(ItemStack item, int count, List<Component> tooltip, Pair<ResourceLocation, ResourceLocation> background, ScreenPosition backgroundOffset) {
                super(tooltip);
                this.item = item.m_41777_();
                this.item.m_41764_(count);
                this.background = background;
                this.backgroundOffset = backgroundOffset;
            }

            private int getTopLeft(int xOrY, int availableWidthOrHeight) {
                return xOrY + availableWidthOrHeight / 2 - 8;
            }

            @Override
            public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
                if (this.item.m_41619_()) {
                    return;
                }
                gui.resetColor();
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                gui.renderSlotBackground(this.background, this.backgroundOffset.offset(left, top));
                gui.renderItem(this.item, left, top);
            }

            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
            }
        }

        private static class EmptySlotEntry
        extends DisplayEntry {
            private final Pair<ResourceLocation, ResourceLocation> background;

            private EmptySlotEntry(Pair<ResourceLocation, ResourceLocation> background, List<Component> tooltip) {
                super(tooltip);
                this.background = background;
            }

            private int getTopLeft(int xOrY, int availableWidthOrHeight) {
                return xOrY + availableWidthOrHeight / 2 - 8;
            }

            @Override
            public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
                gui.resetColor();
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                gui.renderSlotBackground(this.background, left, top);
            }

            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
            }
        }

        private static class TextEntry
        extends DisplayEntry {
            private final Component text;
            private final TextRenderUtil.TextFormatting format;

            private TextEntry(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip) {
                super(tooltip);
                this.text = text;
                this.format = format;
            }

            protected int getTextLeft(int x, int availableWidth) {
                if (this.format.centering().isCenter()) {
                    return x + availableWidth / 2 - this.getTextWidth() / 2;
                }
                if (this.format.centering().isRight()) {
                    return x + availableWidth - this.getTextWidth();
                }
                return x;
            }

            protected int getTextTop(int y, int availableHeight) {
                if (this.format.centering().isMiddle()) {
                    int n = y + availableHeight / 2;
                    Objects.requireNonNull(this.getFont());
                    return n - 9 / 2;
                }
                if (this.format.centering().isBottom()) {
                    Objects.requireNonNull(this.getFont());
                    return y + availableHeight - 9;
                }
                return y;
            }

            protected int getTextWidth() {
                return this.getFont().m_92852_((FormattedText)this.text);
            }

            @Override
            public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
                if (this.text.getString().isBlank()) {
                    return;
                }
                gui.resetColor();
                int left = this.getTextLeft(x + area.xOffset, area.width);
                int top = this.getTextTop(y + area.yOffset, area.height);
                gui.resetColor();
                gui.drawShadowed(this.text, left, top, this.format.color());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = this.getTextLeft(x + area.xOffset, area.width);
                int top = this.getTextTop(y + area.yOffset, area.height);
                if (mouseX < left) return false;
                if (mouseX >= left + this.getTextWidth()) return false;
                if (mouseY < top) return false;
                Objects.requireNonNull(this.getFont());
                if (mouseY >= top + 9) return false;
                return true;
            }
        }

        private static class PriceEntry
        extends DisplayEntry {
            private final CoinValue price;

            public PriceEntry(CoinValue price, List<Component> additionalTooltips, boolean tooltipOverride) {
                super(PriceEntry.getTooltip(price, additionalTooltips, tooltipOverride));
                this.price = price;
            }

            private int getTopLeft(int xOrY, int availableWidthOrHeight) {
                return xOrY + availableWidthOrHeight / 2 - 8;
            }

            private static List<Component> getTooltip(CoinValue price, List<Component> additionalTooltips, boolean tooltipOverride) {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                if (tooltipOverride && additionalTooltips != null) {
                    return additionalTooltips;
                }
                if (!price.isFree() && price.isValid()) {
                    tooltips.add((Component)Component.m_237113_((String)price.getString()));
                }
                if (additionalTooltips != null) {
                    tooltips.addAll(additionalTooltips);
                }
                return tooltips;
            }

            @Override
            public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
                block3: {
                    List<CoinValue.CoinValuePair> entries;
                    block4: {
                        block2: {
                            gui.resetColor();
                            if (!this.price.isFree()) break block2;
                            Font font = this.getFont();
                            int left = x + area.xOffset + area.width / 2 - font.m_92895_(this.price.getString()) / 2;
                            int n = y + area.yOffset + area.height / 2;
                            Objects.requireNonNull(font);
                            int top = n - 9 / 2;
                            gui.drawString(this.price.getString(), left, top, 0xFFFFFF);
                            break block3;
                        }
                        entries = this.price.getEntries();
                        if (entries.size() * 16 > area.width) break block4;
                        List<DisplayData> entryPositions = area.divide(entries.size());
                        for (int i = 0; i < entryPositions.size() && i < entries.size(); ++i) {
                            DisplayData pos = entryPositions.get(i);
                            int left = this.getTopLeft(x + pos.xOffset, pos.width);
                            int top = this.getTopLeft(y + pos.yOffset, pos.height);
                            ItemStack stack = new ItemStack((ItemLike)entries.get((int)i).coin);
                            stack.m_41764_(entries.get((int)i).amount);
                            gui.renderItem(stack, left, top);
                        }
                        break block3;
                    }
                    if (entries.size() <= 0) break block3;
                    int spacing = (area.width - 16) / entries.size();
                    int top = this.getTopLeft(y + area.yOffset, area.height);
                    int left = x + area.xOffset + area.width - 16;
                    for (int i = entries.size() - 1; i >= 0; --i) {
                        ItemStack stack = new ItemStack((ItemLike)entries.get((int)i).coin);
                        stack.m_41764_(entries.get((int)i).amount);
                        gui.renderItem(stack, left, top);
                        left += spacing;
                    }
                }
            }

            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = x + area.xOffset;
                int top = y + area.yOffset;
                return mouseX >= left && mouseX < left + area.width && mouseY >= top && mouseY < top + area.height;
            }
        }
    }

    public record DisplayData(int xOffset, int yOffset, int width, int height) {
        public List<DisplayData> divide(int count) {
            if (count <= 1) {
                return Lists.newArrayList((Object[])new DisplayData[]{this});
            }
            int partialWidth = this.width / count;
            int x = this.xOffset;
            ArrayList<DisplayData> result = new ArrayList<DisplayData>();
            for (int i = 0; i < count; ++i) {
                result.add(new DisplayData(x, this.yOffset, partialWidth, this.height));
                x += partialWidth;
            }
            return result;
        }
    }
}

