/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.easy.IEasyTickable;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CoinValueInput
extends EasyWidgetWithChildren
implements IScrollable,
IEasyTickable {
    public static final long MAX_PRICE = 92233720368547758L;
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/coinvalueinput.png");
    public static final Consumer<CoinValue> EMPTY_CONSUMER = v -> {};
    public static final int HEIGHT = 69;
    public static final int DISPLAY_WIDTH = 176;
    public static final Sprite SPRITE_FREE_TOGGLE = Sprite.SimpleSprite(GUI_TEXTURE, 40, 69, 10, 10);
    public static final Sprite SPRITE_UP_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 0, 69, 20, 10);
    public static final Sprite SPRITE_DOWN_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 20, 69, 20, 10);
    public static final Sprite SPRITE_LEFT_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 50, 69, 10, 20);
    public static final Sprite SPRITE_RIGHT_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 60, 69, 10, 20);
    public static final int MAX_BUTTON_COUNT = 6;
    private static final int SEGMENT_WIDTH = 20;
    private static final int SEGMENT_SPACING = 5;
    private static final int SEGMENT_TOTAL = 25;
    private final CoinValue.ValueType inputType;
    private final Font font;
    private final Consumer<CoinValue> onValueChanged;
    EasyButton buttonLeft;
    EasyButton buttonRight;
    private CoinValue coinValue;
    EasyButton toggleFree;
    private List<EasyButton> increaseButtons;
    private List<EasyButton> decreaseButtons;
    private Component title;
    String lastInput = "";
    EditBox valueInput;
    String prefix;
    String postfix;
    public boolean allowFreeToggle = true;
    public boolean drawBG = true;
    public boolean locked = false;
    int scroll = 0;
    List<CoinData> coinData = new ArrayList<CoinData>();

    public void setTitle(Component title) {
        this.title = title;
    }

    public CoinValueInput(ScreenPosition pos, Component title, CoinValue startingValue, Font font, Consumer<CoinValue> onValueChanged) {
        this(pos.x, pos.y, title, startingValue, font, onValueChanged);
    }

    public CoinValueInput(int x, int y, Component title, CoinValue startingValue, Font font, Consumer<CoinValue> onValueChanged) {
        super(x, y, 176, 69);
        this.inputType = (CoinValue.ValueType)((Object)Config.SERVER.coinValueInputType.get());
        this.title = title;
        this.font = font;
        this.onValueChanged = onValueChanged;
        this.coinValue = startingValue;
        if (this.inputType == CoinValue.ValueType.VALUE) {
            this.setPrefixAndPostfix();
        } else {
            this.getCoinData();
        }
    }

    @Override
    public CoinValueInput withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    @Override
    public void addChildren() {
        this.addChild(new ScrollListener(this.getArea(), this));
        this.toggleFree = this.addChild(new PlainButton(this.m_252754_() + this.f_93618_ - 14, this.m_252907_() + 4, this::ToggleFree, SPRITE_FREE_TOGGLE));
        this.increaseButtons = new ArrayList<EasyButton>();
        this.decreaseButtons = new ArrayList<EasyButton>();
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            int buttonCount = this.coinData.size();
            if (buttonCount > 6) {
                buttonCount = 6;
                this.buttonLeft = this.addChild(new PlainButton(this.m_252754_() + 4, this.m_252907_() + 29, b -> this.scrollLeft(), SPRITE_LEFT_ARROW));
                this.buttonLeft.f_93624_ = false;
                this.buttonRight = this.addChild(new PlainButton(this.m_252754_() + this.f_93618_ - 14, this.m_252907_() + 29, b -> this.scrollRight(), SPRITE_RIGHT_ARROW));
            }
            int startX = this.getStartX() + this.m_252754_();
            for (int x = 0; x < buttonCount; ++x) {
                EasyButton newButton = this.addChild(new PlainButton(startX + x * 25, this.m_252907_() + 15, this::IncreaseButtonHit, SPRITE_UP_ARROW));
                newButton.f_93623_ = true;
                this.increaseButtons.add(newButton);
                newButton = this.addChild(new PlainButton(startX + x * 25, this.m_252907_() + 53, this::DecreaseButtonHit, SPRITE_DOWN_ARROW));
                newButton.f_93623_ = false;
                this.decreaseButtons.add(newButton);
            }
        } else {
            int postfixWidth;
            int prefixWidth = this.font.m_92895_(this.prefix);
            if (prefixWidth > 0) {
                prefixWidth += 2;
            }
            if ((postfixWidth = this.font.m_92895_(this.postfix)) > 0) {
                postfixWidth += 2;
            }
            this.valueInput = this.addChild(new EditBox(this.font, this.m_252754_() + 10 + prefixWidth, this.m_252907_() + 20, 156 - prefixWidth - postfixWidth, 20, (Component)EasyText.empty()));
        }
        this.tick();
    }

    private void setPrefixAndPostfix() {
        String format = (String)Config.SERVER.valueFormat.get();
        String[] splitFormat = format.replace("{value}", "`").split("`", 2);
        if (splitFormat.length < 2) {
            if (format.startsWith("{value}")) {
                this.prefix = "";
                this.postfix = splitFormat[0];
            } else {
                this.prefix = splitFormat[0];
                this.postfix = "";
            }
        } else {
            this.prefix = splitFormat[0];
            this.postfix = splitFormat[1];
        }
    }

    private void getCoinData() {
        this.coinData = MoneyUtil.getAllData("main");
    }

    @Override
    protected void renderTick() {
        this.toggleFree.f_93624_ = this.allowFreeToggle && this.f_93624_;
        this.increaseButtons.forEach(button -> {
            button.f_93624_ = this.f_93624_;
        });
        this.decreaseButtons.forEach(button -> {
            button.f_93624_ = this.f_93624_;
        });
        if (this.valueInput != null) {
            this.valueInput.f_93624_ = this.f_93624_;
        }
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.resetColor();
        if (this.drawBG) {
            gui.blit(GUI_TEXTURE, 0, 0, 0, 0, 176, 69);
        }
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            this.validateScroll();
            int buttonCount = Math.min(this.coinData.size(), 6);
            int startX = this.getStartX();
            for (int x = 0; x < buttonCount; ++x) {
                gui.renderItem(new ItemStack((ItemLike)this.coinData.get((int)(x + this.scroll)).coinItem), startX + x * 25 + 2, 26);
                String countString = String.valueOf(this.coinValue.getEntry(this.coinData.get((int)(x + this.scroll)).coinItem));
                int width = this.font.m_92895_(countString);
                gui.drawString(countString, startX + x * 25 + 10 - width / 2, 43, 0x404040);
            }
        } else if (this.inputType == CoinValue.ValueType.VALUE) {
            gui.drawString(this.prefix, 10, 26, 0xFFFFFF);
            int postfixWidth = this.font.m_92895_(this.postfix);
            gui.drawString(this.postfix, 166 - postfixWidth, 26, 0xFFFFFF);
        }
        int priceWidth = this.font.m_92895_(this.coinValue.getString());
        int freeButtonOffset = this.allowFreeToggle ? 15 : 5;
        gui.drawString((Component)this.coinValue.getComponent(), this.f_93618_ - freeButtonOffset - priceWidth, 5, 0x404040);
        int titleWidth = this.f_93618_ - 7 - freeButtonOffset - priceWidth;
        gui.drawString(TextRenderUtil.fitString(this.title, titleWidth), 8, 5, 0x404040);
    }

    private int getStartX() {
        int buttonCount = Math.min(this.coinData.size(), 6);
        int space = this.f_93618_ - buttonCount * 25 + 5;
        return space / 2;
    }

    @Override
    public void tick() {
        boolean bl = this.toggleFree.f_93623_ = !this.locked;
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            List<Item> coinItems = MoneyUtil.getAllCoins();
            for (int i = 0; i < this.decreaseButtons.size(); ++i) {
                this.decreaseButtons.get((int)i).f_93623_ = i + this.scroll >= coinItems.size() ? false : this.coinValue.getEntry(coinItems.get(i + this.scroll)) > 0 && !this.locked;
            }
            for (EasyButton increaseButton : this.increaseButtons) {
                increaseButton.f_93623_ = !this.coinValue.isFree() && !this.locked;
            }
            if (this.buttonLeft != null) {
                boolean bl2 = this.buttonLeft.f_93624_ = this.scroll > 0;
            }
            if (this.buttonRight != null) {
                this.buttonRight.f_93624_ = this.scroll < this.getMaxScroll();
            }
        } else if (this.valueInput != null) {
            this.valueInput.m_94120_();
            boolean bl3 = this.valueInput.f_93623_ = !this.coinValue.isFree() && !this.locked;
            if (!this.coinValue.isFree()) {
                TextInputUtil.whitelistFloat(this.valueInput);
                if (!this.lastInput.contentEquals(this.valueInput.m_94155_())) {
                    this.lastInput = this.valueInput.m_94155_();
                    this.coinValue = MoneyUtil.displayValueToCoinValue(this.getDisplayValue());
                    this.onValueChanged.accept(this.coinValue);
                }
            } else {
                this.valueInput.m_94144_("");
                this.lastInput = this.valueInput.m_94155_();
            }
        }
    }

    public void IncreaseButtonHit(EasyButton button) {
        if (!this.increaseButtons.contains((Object)button)) {
            return;
        }
        int coinIndex = this.increaseButtons.indexOf((Object)button);
        if (coinIndex < 0) {
            return;
        }
        if ((coinIndex += this.scroll) >= 0 && coinIndex < this.coinData.size()) {
            Item coin = this.coinData.get((int)coinIndex).coinItem;
            int addAmount = 1;
            if (Screen.m_96638_()) {
                addAmount = this.getLargeIncreaseAmount(coin);
            }
            if (Screen.m_96637_()) {
                addAmount *= 10;
            }
            this.coinValue = this.coinValue.plusValue(coin, addAmount);
            this.ValidateValue();
            this.onValueChanged.accept(this.coinValue);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the increasing button.");
        }
    }

    public void DecreaseButtonHit(EasyButton button) {
        if (!this.decreaseButtons.contains((Object)button)) {
            return;
        }
        int coinIndex = this.decreaseButtons.indexOf((Object)button);
        if (coinIndex < 0) {
            return;
        }
        if ((coinIndex += this.scroll) >= 0 && coinIndex < this.coinData.size()) {
            Item coin = this.coinData.get((int)coinIndex).coinItem;
            int removeAmount = 1;
            if (Screen.m_96638_()) {
                removeAmount = this.getLargeIncreaseAmount(coin);
            }
            if (Screen.m_96637_()) {
                removeAmount *= 10;
            }
            this.coinValue = this.coinValue.minusValue(coin, removeAmount);
            this.onValueChanged.accept(this.coinValue);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the decreasing button.");
        }
    }

    private int getLargeIncreaseAmount(Item coinItem) {
        Pair<Item, Integer> upwardConversion = MoneyUtil.getUpwardConversion(coinItem);
        if (upwardConversion != null) {
            return this.getLargeAmount(upwardConversion);
        }
        Pair<Item, Integer> downwardConversion = MoneyUtil.getDownwardConversion(coinItem);
        if (downwardConversion != null) {
            return this.getLargeAmount(downwardConversion);
        }
        return 10;
    }

    private int getLargeAmount(Pair<Item, Integer> conversion) {
        if ((Integer)conversion.getSecond() >= 64) {
            return 16;
        }
        if ((Integer)conversion.getSecond() > 10) {
            return 10;
        }
        if ((Integer)conversion.getSecond() > 5) {
            return 5;
        }
        return 2;
    }

    private void ToggleFree(EasyButton button) {
        this.coinValue = this.coinValue.isFree() ? CoinValue.EMPTY : CoinValue.FREE;
        this.onValueChanged.accept(this.coinValue);
    }

    public CoinValue getCoinValue() {
        return this.coinValue;
    }

    public double getDisplayValue() {
        if (this.valueInput != null) {
            return TextInputUtil.getDoubleValue(this.valueInput);
        }
        return this.coinValue.getDisplayValue();
    }

    public void setCoinValue(CoinValue newValue) {
        this.coinValue = newValue;
        this.ValidateValue();
        if (this.inputType == CoinValue.ValueType.VALUE && this.valueInput != null) {
            this.valueInput.m_94144_(Config.formatValueOnly(newValue.getDisplayValue()));
        }
    }

    private void scrollLeft() {
        --this.scroll;
        this.validateScroll();
    }

    private void scrollRight() {
        ++this.scroll;
        this.validateScroll();
    }

    private void ValidateValue() {
        if (this.coinValue.getValueNumber() > 92233720368547758L) {
            this.coinValue = CoinValue.fromNumber(92233720368547758L);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = Math.max(newScroll, this.getMaxScroll());
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(6, this.coinData.size());
    }
}

