/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;

public class TooltipUtil {
    @Nullable
    public static List<Component> lazyList(Component entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(entry);
        return list;
    }

    @NotNull
    public static Supplier<List<Component>> createToggleTooltip(@NotNull NonNullSupplier<Boolean> toggle, List<Component> trueTooltip, List<Component> falseTooltip) {
        return () -> {
            if (((Boolean)toggle.get()).booleanValue()) {
                return trueTooltip;
            }
            return falseTooltip;
        };
    }

    @NotNull
    public static Supplier<List<Component>> createToggleSingleTooltip(@NotNull NonNullSupplier<Boolean> toggle, Component trueTooltip, Component falseTooltip) {
        return () -> {
            if (((Boolean)toggle.get()).booleanValue()) {
                return TooltipUtil.lazyList(trueTooltip);
            }
            return TooltipUtil.lazyList(falseTooltip);
        };
    }

    @NotNull
    public static Supplier<List<Component>> createToggleTooltip(@NotNull NonNullSupplier<Boolean> toggle, Supplier<List<Component>> trueTooltip, Supplier<List<Component>> falseTooltip) {
        return () -> {
            if (((Boolean)toggle.get()).booleanValue()) {
                return (List)trueTooltip.get();
            }
            return (List)falseTooltip.get();
        };
    }

    @NotNull
    public static Supplier<List<Component>> createToggleSingleTooltip(@NotNull NonNullSupplier<Boolean> toggle, Supplier<Component> trueTooltip, Supplier<Component> falseTooltip) {
        return () -> {
            if (((Boolean)toggle.get()).booleanValue()) {
                return TooltipUtil.lazyList((Component)trueTooltip.get());
            }
            return TooltipUtil.lazyList((Component)falseTooltip.get());
        };
    }
}

