/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageDisbandTeam;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageEditTeam;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TeamOwnerTab
extends TeamTab {
    EditBox newOwnerName;
    EasyButton buttonChangeOwner;
    EasyButton buttonDisbandTeam;

    public TeamOwnerTab(TeamManagerScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42614_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.team.owner", new Object[0]);
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null && team.isOwner(player);
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        if (this.getActiveTeam() == null) {
            this.screen.changeTab(0);
            return;
        }
        this.newOwnerName = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 20, 160, 20, (Component)EasyText.empty()));
        this.newOwnerName.m_94199_(16);
        this.buttonChangeOwner = this.addChild(new EasyTextButton(screenArea.pos.offset(20, 45), 160, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::setNewOwner).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("tooltip.lightmanscurrency.warning", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}))));
        this.buttonChangeOwner.f_93623_ = false;
        this.buttonDisbandTeam = this.addChild(new EasyTextButton(screenArea.pos.offset(20, 160), 160, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.team.disband", new Object[0]), this::disbandTeam).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("tooltip.lightmanscurrency.warning", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}))));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.getActiveTeam() == null) {
            return;
        }
        gui.drawString((Component)EasyText.translatable("gui.button.lightmanscurrency.team.owner", this.getActiveTeam().getOwner().getName(true)), 20, 10, 0x404040);
    }

    @Override
    public void tick() {
        this.newOwnerName.m_94120_();
        this.buttonChangeOwner.f_93623_ = !this.newOwnerName.m_94155_().isBlank();
    }

    private void setNewOwner(EasyButton button) {
        if (this.newOwnerName.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeOwner(this.getPlayer(), this.newOwnerName.m_94155_());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.newOwnerName.m_94155_(), "OWNER"));
        this.newOwnerName.m_94144_("");
    }

    private void disbandTeam(EasyButton button) {
        if (this.getActiveTeam() == null) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageDisbandTeam(this.getActiveTeam().getID()));
    }
}

