/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerDiscounts;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class PlayerDiscountTab
extends TradeRuleSubTab<PlayerDiscounts> {
    EditBox nameInput;
    EditBox discountInput;
    EasyButton buttonAddPlayer;
    EasyButton buttonRemovePlayer;
    EasyButton buttonSetDiscount;
    ScrollTextDisplay playerList;

    public PlayerDiscountTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, PlayerDiscounts.TYPE);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_DISCOUNT_LIST;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.nameInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 34, screenArea.width - 20, 20, (Component)EasyText.empty()));
        this.buttonAddPlayer = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 55), 78, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.discount.add", new Object[0]), this::PressAddButton));
        this.buttonRemovePlayer = this.addChild(new EasyTextButton(screenArea.pos.offset(screenArea.width - 88, 55), 78, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.discount.remove", new Object[0]), this::PressForgetButton));
        this.discountInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 9, 20, 20, (Component)EasyText.empty()));
        this.discountInput.m_94199_(2);
        PlayerDiscounts rule = (PlayerDiscounts)this.getRule();
        if (rule != null) {
            this.discountInput.m_94144_(Integer.toString(rule.getDiscount()));
        }
        this.buttonSetDiscount = this.addChild(new EasyTextButton(screenArea.pos.offset(110, 10), 50, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.discount.set", new Object[0]), this::PressSetDiscountButton));
        this.playerList = this.addChild(new ScrollTextDisplay(screenArea.pos.offset(7, 78), screenArea.width - 14, 61, (Supplier<List<? extends Component>>)((Supplier)this::getPlayerList)));
        this.playerList.setColumnCount(2);
    }

    private List<Component> getPlayerList() {
        ArrayList playerList = Lists.newArrayList();
        PlayerDiscounts rule = (PlayerDiscounts)this.getRule();
        if (rule == null) {
            return playerList;
        }
        for (PlayerReference player : rule.getPlayerList()) {
            playerList.add(player.getNameComponent(true));
        }
        return playerList;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.getRule() == null) {
            return;
        }
        gui.pushOffset((AbstractWidget)this.discountInput);
        gui.drawString(EasyText.translatable("gui.lightmanscurrency.discount.tooltip", new Object[0]).getString(), this.discountInput.m_5711_() + 4, 3, 0xFFFFFF);
        gui.popOffset();
    }

    @Override
    public void tick() {
        TextInputUtil.whitelistInteger(this.discountInput, 0L, 100L);
    }

    void PressAddButton(EasyButton button) {
        String name = this.nameInput.m_94155_();
        if (!name.isBlank()) {
            this.nameInput.m_94144_("");
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128379_("Add", true);
            updateInfo.m_128359_("Name", name);
            this.sendUpdateMessage(updateInfo);
        }
    }

    void PressForgetButton(EasyButton button) {
        String name = this.nameInput.m_94155_();
        if (!name.isBlank()) {
            this.nameInput.m_94144_("");
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128379_("Add", false);
            updateInfo.m_128359_("Name", name);
            this.sendUpdateMessage(updateInfo);
        }
    }

    void PressSetDiscountButton(EasyButton button) {
        int discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
        PlayerDiscounts rule = (PlayerDiscounts)this.getRule();
        if (rule != null) {
            rule.setDiscount(discount);
        }
        CompoundTag updateInfo = new CompoundTag();
        updateInfo.m_128405_("Discount", discount);
        this.sendUpdateMessage(updateInfo);
    }
}

