/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachineStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SlotMachineStorageClientTab
extends TraderStorageClientTab<SlotMachineStorageTab>
implements IScrollable,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS_NORMAL = 8;
    private static final int COLUMNS_PERSISTENT = 10;
    private static final int ROWS = 5;
    int scroll = 0;
    ScrollBarWidget scrollBar;
    int columns = 8;

    public SlotMachineStorageClientTab(Object screen, SlotMachineStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORAGE;
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.trader.storage", new Object[0]);
    }

    @Override
    public boolean tabButtonVisible() {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        SlotMachineTraderData trader;
        this.addChild(this);
        this.columns = 8;
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData && (trader = (SlotMachineTraderData)traderData).isPersistent()) {
            this.columns = 10;
        }
        this.scrollBar = this.addChild(new ScrollBarWidget(screenArea.pos.offset(13 + 18 * this.columns, 17), 90, this));
        this.addChild(new ScrollListener(screenArea.pos, screenArea.width, 118, this));
        traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData && !(trader = (SlotMachineTraderData)traderData).isPersistent()) {
            this.addChild(IconAndButtonUtil.quickInsertButton(screenArea.pos.offset(22, 115), b -> ((SlotMachineStorageTab)this.commonTab).quickTransfer(0)));
            this.addChild(IconAndButtonUtil.quickExtractButton(screenArea.pos.offset(34, 115), b -> ((SlotMachineStorageTab)this.commonTab).quickTransfer(1)));
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.storage", new Object[0]), 8, 6, 0x404040);
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            this.validateScroll();
            int index = this.scroll * this.columns;
            TraderItemStorage storage = trader.getStorage();
            int hoverSlot = this.isMouseOverSlot(gui.mousePos) + this.scroll * this.columns;
            for (int y = 0; y < 5; ++y) {
                int n = 17 + y * 18;
                for (int x = 0; x < this.columns; ++x) {
                    int xPos = 13 + x * 18;
                    gui.resetColor();
                    gui.blit(TraderScreen.GUI_TEXTURE, xPos, n, 206, 0, 18, 18);
                    if (index < storage.getSlotCount()) {
                        gui.renderItem(storage.getContents().get(index), xPos + 1, n + 1, this.getCountText(storage.getContents().get(index)));
                    }
                    if (index == hoverSlot) {
                        gui.renderSlotHighlight(xPos + 1, n + 1);
                    }
                    ++index;
                }
            }
            gui.resetColor();
            for (Slot slot : ((SlotMachineStorageTab)this.commonTab).getSlots()) {
                gui.blit(TraderScreen.GUI_TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, 206, 0, 18, 18);
            }
        }
    }

    private String getCountText(ItemStack stack) {
        int count = stack.m_41613_();
        if (count <= 1) {
            return null;
        }
        if (count >= 1000) {
            Object countText = String.valueOf(count / 1000);
            if (count % 1000 / 100 > 0) {
                countText = (String)countText + "." + count % 1000 / 100;
            }
            return (String)countText + "k";
        }
        return String.valueOf(count);
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            TraderItemStorage storage;
            int hoveredSlot;
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            if (((TraderStorageMenu)this.screen.m_6262_()).m_142621_().m_41619_() && (hoveredSlot = this.isMouseOverSlot(gui.mousePos)) >= 0 && (hoveredSlot += this.scroll * this.columns) < (storage = trader.getStorage()).getContents().size()) {
                ItemStack stack = storage.getContents().get(hoveredSlot);
                List<Component> tooltip = EasyScreenHelper.getTooltipFromItem(stack);
                tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.itemstorage", stack.m_41613_()));
                if (stack.m_41613_() >= 64) {
                    if (stack.m_41613_() % 64 == 0) {
                        tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.itemstorage.stacks.single", stack.m_41613_() / 64));
                    } else {
                        tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.itemstorage.stacks.multi", stack.m_41613_() / 64, stack.m_41613_() % 64));
                    }
                }
                gui.renderComponentTooltip(tooltip);
            }
        }
    }

    private int isMouseOverSlot(ScreenPosition mousePos) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 5 && foundRow < 0; ++y) {
            if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * this.columns + foundColumn;
    }

    private int totalStorageSlots() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            return trader.getStorage().getContents().size();
        }
        return 0;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (this.menu.getTrader() instanceof SlotMachineTraderData && (hoveredSlot = this.isMouseOverSlot(ScreenPosition.of(mouseX, mouseY))) >= 0) {
            ((SlotMachineStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * this.columns, Screen.m_96638_(), button == 0);
            return true;
        }
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / this.columns - 5 + 1, 0);
    }
}

