/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.input;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.input.InputTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InputTab
extends SettingsSubTab {
    DirectionalSettingsWidget inputWidget;
    DirectionalSettingsWidget outputWidget;

    public InputTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    protected InputTraderData getInputTrader() {
        TraderData trader = this.menu.getTrader();
        if (trader instanceof InputTraderData) {
            return (InputTraderData)trader;
        }
        return null;
    }

    protected boolean getInputSideValue(Direction side) {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.allowInputSide(side);
        }
        return false;
    }

    protected boolean getOutputSideValue(Direction side) {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.allowOutputSide(side);
        }
        return false;
    }

    protected ImmutableList<Direction> getIgnoreList() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.ignoreSides;
        }
        return ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.EAST, (Object)Direction.WEST, (Object)Direction.UP, (Object)Direction.DOWN);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.inputSettingsTabIcon();
        }
        return IconData.of((ItemLike)Items.f_42155_);
    }

    public MutableComponent getTooltip() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.inputSettingsTabTooltip();
        }
        return EasyText.translatable("tooltip.lightmanscurrency.settings.iteminput", new Object[0]);
    }

    public List<? extends InputTabAddon> getAddons() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.inputSettingsAddons();
        }
        return ImmutableList.of();
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("changeExternalInputs");
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.inputWidget = new DirectionalSettingsWidget(screenArea.pos.offset(20, 25), this::getInputSideValue, this.getIgnoreList(), this::ToggleInputSide, this::addChild);
        this.outputWidget = new DirectionalSettingsWidget(screenArea.pos.offset(110, 25), this::getOutputSideValue, this.getIgnoreList(), this::ToggleOutputSide, this::addChild);
        this.getAddons().forEach(a -> a.onOpen(this, screenArea, firstOpen));
    }

    @Override
    protected void onSubtabClose() {
        this.getAddons().forEach(a -> a.onClose(this));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.iteminput.side", new Object[0]), 20, 7, 0x404040);
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.itemoutput.side", new Object[0]), 110, 7, 0x404040);
        this.getAddons().forEach(a -> a.renderBG(this, gui));
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        this.getAddons().forEach(a -> a.renderBG(this, gui));
    }

    @Override
    public void tick() {
        this.getAddons().forEach(a -> a.tick(this));
    }

    private void ToggleInputSide(Direction side) {
        CompoundTag message = new CompoundTag();
        message.m_128379_("SetInputSide", !this.getInputSideValue(side));
        message.m_128405_("Side", side.m_122411_());
        this.sendNetworkMessage(message);
    }

    private void ToggleOutputSide(Direction side) {
        CompoundTag message = new CompoundTag();
        message.m_128379_("SetOutputSide", !this.getOutputSideValue(side));
        message.m_128405_("Side", side.m_122411_());
        this.sendNetworkMessage(message);
    }
}

