/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertType;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class TaxSettingsTab
extends SettingsSubTab {
    public TaxSettingsTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TAXES;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.settings.taxes", new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return true;
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(IconAndButtonUtil.plusButton(screenArea.pos.offset(20, 30), this::increaseAcceptableTaxRate).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.getAcceptableTaxRate() < 99))));
        this.addChild(IconAndButtonUtil.minusButton(screenArea.pos.offset(20, 40), this::decreaseAcceptableTaxRate).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.getAcceptableTaxRate() > 0))));
        this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.pos.offset(30, 80), this::toggleIgnoreAllTaxes, (NonNullSupplier<Boolean>)((NonNullSupplier)this::getIgnoreAllTaxes)).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::isIgnoreAllTaxesVisible))));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            int acceptableRate;
            int totalRate = trader.getTotalTaxPercentage();
            int color = totalRate > (acceptableRate = trader.getAcceptableTaxRate()) ? AlertType.ERROR.color : (totalRate == acceptableRate ? AlertType.WARN.color : AlertType.HELPFUL.color);
            TextRenderUtil.drawCenteredText(gui, (Component)EasyText.translatable("tooltip.lightmanscurrency.trader.tax_info.total_rate", totalRate), this.screen.getXSize() / 2, 16, color);
        }
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.acceptabletaxrate", this.getAcceptableTaxRate()), 34, 37, 0x404040);
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.acceptabletaxrate", this.getAcceptableTaxRate()), 34, 37, 0x404040);
        if (this.isIgnoreAllTaxesVisible()) {
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.ingoretaxes", new Object[0]), 40, 82, 0x404040);
        }
    }

    private boolean isIgnoreAllTaxesVisible() {
        return CommandLCAdmin.isAdminPlayer(this.menu.player) || this.getIgnoreAllTaxes();
    }

    private boolean getIgnoreAllTaxes() {
        TraderData trader = this.menu.getTrader();
        return trader != null && trader.ShouldIgnoreAllTaxes();
    }

    private int getAcceptableTaxRate() {
        TraderData trader = this.menu.getTrader();
        return trader != null ? trader.getAcceptableTaxRate() : 0;
    }

    private void toggleIgnoreAllTaxes(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            CompoundTag message = new CompoundTag();
            message.m_128379_("ForceIgnoreAllTaxCollectors", !trader.ShouldIgnoreAllTaxes());
            this.sendNetworkMessage(message);
        }
    }

    private void increaseAcceptableTaxRate(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            int oldRate = trader.getAcceptableTaxRate();
            int newRate = Screen.m_96638_() ? oldRate + 10 : oldRate + 1;
            CompoundTag message = new CompoundTag();
            message.m_128405_("AcceptableTaxRate", newRate);
            this.sendNetworkMessage(message);
        }
    }

    private void decreaseAcceptableTaxRate(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            int oldRate = trader.getAcceptableTaxRate();
            int newRate = Screen.m_96638_() ? oldRate - 10 : oldRate - 1;
            CompoundTag message = new CompoundTag();
            message.m_128405_("AcceptableTaxRate", newRate);
            this.sendNetworkMessage(message);
        }
    }
}

