/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class NotificationTab
extends SettingsSubTab {
    PlainButton buttonToggleNotifications;
    PlainButton buttonToggleChatNotifications;
    EasyButton buttonToggleTeamLevel;

    public NotificationTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42584_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.settings.notifications", new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("notifications");
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.buttonToggleNotifications = this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.pos.offset(35, 35), this::ToggleNotifications, (NonNullSupplier<Boolean>)((NonNullSupplier)this::notificationsEnabled)));
        this.buttonToggleChatNotifications = this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.pos.offset(35, 55), this::ToggleChatNotifications, (NonNullSupplier<Boolean>)((NonNullSupplier)this::notificationsToChat)));
        this.buttonToggleTeamLevel = this.addChild(new EasyTextButton(screenArea.pos.offset(20, 80), screenArea.width - 40, 20, (Component)EasyText.empty(), this::ToggleTeamNotificationLevel));
    }

    private boolean notificationsEnabled() {
        TraderData t = this.menu.getTrader();
        return t != null && t.notificationsEnabled();
    }

    private boolean notificationsToChat() {
        TraderData t = this.menu.getTrader();
        return t != null && t.notificationsToChat();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.notifications.enabled", new Object[0]), 47, 35, 0x404040);
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.notifications.chat", new Object[0]), 47, 55, 0x404040);
        this.buttonToggleTeamLevel.f_93624_ = trader.getOwner().hasTeam();
        if (this.buttonToggleTeamLevel.f_93624_) {
            MutableComponent message = EasyText.translatable("gui.button.lightmanscurrency.team.bank.notifications", EasyText.translatable("gui.button.lightmanscurrency.team.bank.limit." + trader.teamNotificationLevel(), new Object[0]));
            this.buttonToggleTeamLevel.m_93666_((Component)message);
        }
    }

    private void ToggleNotifications(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        CompoundTag message = new CompoundTag();
        message.m_128379_("Notifications", !trader.notificationsEnabled());
        this.sendNetworkMessage(message);
    }

    private void ToggleChatNotifications(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        CompoundTag message = new CompoundTag();
        message.m_128379_("NotificationsToChat", !trader.notificationsToChat());
        this.sendNetworkMessage(message);
    }

    private void ToggleTeamNotificationLevel(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        CompoundTag message = new CompoundTag();
        message.m_128405_("TeamNotificationLevel", Team.NextBankLimit(trader.teamNotificationLevel()));
        this.sendNetworkMessage(message);
    }
}

