/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.MessageAddPersistentTrader;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageAddOrRemoveTrade;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class MainTab
extends SettingsSubTab {
    EditBox nameInput;
    EasyButton buttonSetName;
    EasyButton buttonResetName;
    PlainButton buttonToggleBankLink;
    IconButton buttonToggleCreative;
    EasyButton buttonAddTrade;
    EasyButton buttonRemoveTrade;
    EasyButton buttonSavePersistentTrader;
    EditBox persistentTraderIDInput;
    EditBox persistentTraderOwnerInput;

    public MainTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModItems.TRADING_CORE);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.settings.name", new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.nameInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 25, 160, 20, (Component)EasyText.empty()));
        this.nameInput.m_94199_(32);
        this.nameInput.m_94144_(trader.getCustomName());
        this.buttonSetName = this.addChild(new EasyTextButton(screenArea.pos.offset(20, 50), 74, 20, (Component)EasyText.translatable("gui.lightmanscurrency.changename", new Object[0]), this::SetName));
        this.buttonResetName = this.addChild(new EasyTextButton(screenArea.pos.offset(screenArea.width - 93, 50), 74, 20, (Component)EasyText.translatable("gui.lightmanscurrency.resetname", new Object[0]), this::ResetName));
        this.buttonToggleCreative = this.addChild(IconAndButtonUtil.creativeToggleButton(screenArea.pos.offset(176, 110), this::ToggleCreative, (NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.menu.getTrader().isCreative())));
        this.buttonAddTrade = this.addChild(IconAndButtonUtil.plusButton(screenArea.pos.offset(166, 110), this::AddTrade).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("tooltip.lightmanscurrency.trader.creative.addTrade", new Object[0]))));
        this.buttonRemoveTrade = this.addChild(IconAndButtonUtil.minusButton(screenArea.pos.offset(166, 120), this::RemoveTrade).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("tooltip.lightmanscurrency.trader.creative.removeTrade", new Object[0]))));
        this.buttonToggleBankLink = this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.pos.offset(20, 72), this::ToggleBankLink, (NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TraderData t = this.menu.getTrader();
            return t != null && t.getLinkedToBank();
        })));
        this.buttonToggleBankLink.f_93624_ = this.menu.hasPermission("bankLink");
        this.buttonSavePersistentTrader = this.addChild(new IconButton(screenArea.pos.offset(10, 110), this::SavePersistentTraderData, IconAndButtonUtil.ICON_PERSISTENT_DATA).withAddons(EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_PERSISTENT_TRADER)));
        this.buttonSavePersistentTrader.f_93624_ = CommandLCAdmin.isAdminPlayer(this.menu.player);
        int idWidth = this.getFont().m_92852_((FormattedText)EasyText.translatable("gui.lightmanscurrency.settings.persistent.id", new Object[0]));
        this.persistentTraderIDInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 37 + idWidth, screenArea.y + 110, 108 - idWidth, 18, (Component)EasyText.empty()));
        int ownerWidth = this.getFont().m_92852_((FormattedText)EasyText.translatable("gui.lightmanscurrency.settings.persistent.owner", new Object[0]));
        this.persistentTraderOwnerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 12 + ownerWidth, screenArea.y + 85, 178 - ownerWidth, 18, (Component)EasyText.empty()));
        this.tick();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.menu.getTrader();
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.customname", new Object[0]), 20, 15, 0x404040);
        if (this.menu.hasPermission("bankLink")) {
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.banklink", new Object[0]), 32, 73, 0x404040);
        }
        if (CommandLCAdmin.isAdminPlayer(this.menu.player) && trader != null) {
            String count = String.valueOf(trader.getTradeCount());
            int width = gui.font.m_92895_(count);
            gui.drawString(count, 164 - width, 115, 0x404040);
            if (this.persistentTraderIDInput != null) {
                gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.persistent.id", new Object[0]), 35, 115, 0xFFFFFF);
                gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.persistent.owner", new Object[0]), 10, 90, 0xFFFFFF);
            }
        }
    }

    @Override
    public void tick() {
        boolean canLinkAccount;
        boolean isAdmin;
        boolean canChangeName = this.menu.hasPermission("changeName");
        this.nameInput.m_94186_(canChangeName);
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.buttonSetName.f_93623_ = !this.nameInput.m_94155_().contentEquals(trader.getCustomName());
        this.buttonSetName.f_93624_ = canChangeName;
        this.buttonResetName.f_93623_ = trader.hasCustomName();
        this.buttonResetName.f_93624_ = canChangeName;
        this.buttonToggleCreative.f_93624_ = isAdmin = CommandLCAdmin.isAdminPlayer(this.menu.player);
        if (this.buttonToggleCreative.f_93624_) {
            this.buttonAddTrade.f_93624_ = true;
            this.buttonAddTrade.f_93623_ = trader.getTradeCount() < 100;
            this.buttonRemoveTrade.f_93624_ = true;
            this.buttonRemoveTrade.f_93623_ = trader.getTradeCount() > 1;
        } else {
            this.buttonAddTrade.f_93624_ = false;
            this.buttonRemoveTrade.f_93624_ = false;
        }
        this.buttonToggleBankLink.f_93624_ = canLinkAccount = this.menu.hasPermission("bankLink");
        if (canLinkAccount) {
            boolean bl = this.buttonToggleBankLink.f_93623_ = trader.canLinkBankAccount() || trader.getLinkedToBank();
        }
        if (this.buttonSavePersistentTrader != null) {
            this.buttonSavePersistentTrader.f_93624_ = isAdmin;
            this.buttonSavePersistentTrader.f_93623_ = trader.hasValidTrade();
        }
        if (this.persistentTraderIDInput != null) {
            this.persistentTraderIDInput.f_93624_ = isAdmin;
            this.persistentTraderIDInput.m_94120_();
        }
        if (this.persistentTraderOwnerInput != null) {
            this.persistentTraderOwnerInput.f_93624_ = isAdmin;
            this.persistentTraderOwnerInput.m_94120_();
        }
    }

    private void SetName(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        String customName = trader.getCustomName();
        if (!customName.contentEquals(this.nameInput.m_94155_())) {
            CompoundTag message = new CompoundTag();
            message.m_128359_("ChangeName", this.nameInput.m_94155_());
            this.sendNetworkMessage(message);
        }
    }

    private void ResetName(EasyButton button) {
        this.nameInput.m_94144_("");
        this.SetName(button);
    }

    private void ToggleCreative(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        CompoundTag message = new CompoundTag();
        message.m_128379_("MakeCreative", !trader.isCreative());
        this.sendNetworkMessage(message);
    }

    private void ToggleBankLink(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        CompoundTag message = new CompoundTag();
        message.m_128379_("LinkToBankAccount", !trader.getLinkedToBank());
        this.sendNetworkMessage(message);
    }

    private void AddTrade(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddOrRemoveTrade(trader.getID(), true));
    }

    private void RemoveTrade(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddOrRemoveTrade(trader.getID(), false));
    }

    private void SavePersistentTraderData(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader != null && trader.canMakePersistent()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddPersistentTrader(trader.getID(), this.persistentTraderIDInput.m_94155_(), this.persistentTraderOwnerInput.m_94155_()));
        }
    }
}

