/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.item;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.item.ItemTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullSupplier;

public class ItemTradeEditClientTab
extends TraderStorageClientTab<ItemTradeEditTab>
implements TradeButtonArea.InteractionConsumer,
ItemEditWidget.IItemEditListener,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 71;
    private static final int COLUMNS = 10;
    private static final int ROWS = 2;
    TradeButton tradeDisplay;
    CoinValueInput priceSelection;
    EditBox customNameInput;
    ItemEditWidget itemEdit = null;
    ScrollBarWidget itemEditScroll;
    EasyButton buttonToggleTradeType;
    PlainButton buttonToggleNBTEnforcement;
    private int selection = -1;
    private int itemEditScrollValue = -1;

    public ItemTradeEditClientTab(Object screen, ItemTradeEditTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.BLANK;
    }

    public MutableComponent getTooltip() {
        return EasyText.empty();
    }

    @Override
    public boolean tabButtonVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public int getTradeRuleTradeIndex() {
        return ((ItemTradeEditTab)this.commonTab).getTradeIndex();
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(this);
        ItemTradeData trade = this.getTrade();
        this.tradeDisplay = this.addChild(new TradeButton(this.menu::getContext, ((ItemTradeEditTab)this.commonTab)::getTrade, button -> {}));
        this.tradeDisplay.setPosition(screenArea.pos.offset(10, 18));
        this.priceSelection = this.addChild(new CoinValueInput(screenArea.pos.offset(15, 40), (Component)EasyText.empty(), trade == null ? CoinValue.EMPTY : trade.getCost(), this.getFont(), this::onValueChanged));
        this.priceSelection.drawBG = false;
        this.itemEdit = this.addChild(new ItemEditWidget(screenArea.pos.offset(13, 71), 10, 2, this.itemEdit, this));
        if (this.itemEditScrollValue >= 0) {
            this.itemEdit.setScroll(this.itemEditScrollValue);
        }
        this.itemEditScroll = this.addChild(new ScrollBarWidget(screenArea.pos.offset(193, 71), 36, this.itemEdit));
        this.itemEditScroll.smallKnob = true;
        int labelWidth = this.getFont().m_92852_((FormattedText)EasyText.translatable("gui.lightmanscurrency.customname", new Object[0]));
        this.customNameInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 15 + labelWidth, screenArea.y + 38, screenArea.width - 28 - labelWidth, 18, (Component)EasyText.empty()));
        if (this.selection >= 0 && this.selection < 2 && trade != null) {
            this.customNameInput.m_94144_(trade.getCustomName(this.selection));
        }
        this.buttonToggleTradeType = this.addChild(new EasyTextButton(screenArea.pos.offset(113, 15), 80, 20, (Component)EasyText.empty(), this::ToggleTradeType));
        this.buttonToggleNBTEnforcement = this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.pos.offset(113, 4), this::ToggleNBTEnforcement, (NonNullSupplier<Boolean>)((NonNullSupplier)this::getEnforceNBTState)));
    }

    private boolean getEnforceNBTState() {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            return trade.getEnforceNBT(this.selection);
        }
        return true;
    }

    @Override
    public void closeAction() {
        this.selection = -1;
        this.itemEditScrollValue = -1;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.getTrade() == null) {
            return;
        }
        this.validateRenderables();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TraderScreen.GUI_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.resetColor();
        gui.blit(TraderScreen.GUI_TEXTURE, this.getArrowPosition(), 10, 214, 18, 8, 6);
        if (this.customNameInput.f_93624_) {
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.customname", new Object[0]), 13, 42, 0x404040);
        }
        if (this.isNBTButtonVisible()) {
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.blurb.nbt", new Object[0]), 124, 5, 0x404040);
        }
    }

    private int getArrowPosition() {
        ItemTradeData trade = this.getTrade();
        if (this.selection == -1) {
            if (trade.isSale()) {
                return 25;
            }
            if (trade.isPurchase()) {
                return 81;
            }
            return -1000;
        }
        if (this.selection >= 2 && !trade.isBarter()) {
            return -1000;
        }
        int horizSlot = this.selection;
        if (trade.isSale() || trade.isBarter()) {
            horizSlot += 2;
        }
        int spacing = horizSlot % 4 >= 2 ? 20 : 0;
        return 16 + 18 * (horizSlot % 4) + spacing;
    }

    private void validateRenderables() {
        boolean bl = this.priceSelection.f_93624_ = this.selection < 0 && !this.getTrade().isBarter();
        if (this.priceSelection.f_93624_) {
            this.priceSelection.tick();
        }
        this.itemEditScroll.f_93624_ = this.getTrade().isBarter() && this.selection >= 2 || this.getTrade().isPurchase() && this.selection >= 0;
        this.itemEdit.f_93624_ = this.itemEditScroll.f_93624_;
        boolean bl2 = this.customNameInput.f_93624_ = this.selection >= 0 && this.selection < 2 && !this.getTrade().isPurchase();
        if (this.customNameInput.f_93624_ && !this.customNameInput.m_94155_().contentEquals(this.getTrade().getCustomName(this.selection))) {
            ((ItemTradeEditTab)this.commonTab).setCustomName(this.selection, this.customNameInput.m_94155_());
        }
        this.buttonToggleTradeType.m_93666_((Component)EasyText.translatable("gui.button.lightmanscurrency.tradedirection." + this.getTrade().getTradeType().name().toLowerCase(), new Object[0]));
    }

    @Override
    public void tick() {
        if (this.customNameInput.f_93624_) {
            this.customNameInput.m_94120_();
        }
        this.buttonToggleNBTEnforcement.f_93624_ = this.isNBTButtonVisible();
        if (this.itemEdit.f_93624_) {
            this.itemEdit.tick();
            this.itemEditScrollValue = this.itemEdit.currentScroll();
        }
    }

    private boolean isNBTButtonVisible() {
        ItemTradeData trade = this.getTrade();
        if (trade == null) {
            return false;
        }
        return this.selection >= 0 && !trade.alwaysEnforcesNBT(this.selection);
    }

    @Override
    public void receiveSelfMessage(CompoundTag message) {
        if (message.m_128441_("TradeIndex")) {
            ((ItemTradeEditTab)this.commonTab).setTradeIndex(message.m_128451_("TradeIndex"));
        }
        if (message.m_128441_("StartingSlot")) {
            this.selection = message.m_128451_("StartingSlot");
        }
    }

    @Override
    public void onTradeButtonInputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trade instanceof ItemTradeData) {
            ItemTradeData t = (ItemTradeData)trade;
            ItemStack heldItem = this.menu.m_142621_();
            if (t.isSale()) {
                this.changeSelection(-1);
            } else if (t.isPurchase()) {
                if (this.selection != index && heldItem.m_41619_()) {
                    this.changeSelection(index);
                } else {
                    ((ItemTradeEditTab)this.commonTab).defaultInteraction(index, heldItem, mouseButton);
                }
            } else if (t.isBarter()) {
                if (this.selection != index + 2 && heldItem.m_41619_()) {
                    this.changeSelection(index + 2);
                } else {
                    ((ItemTradeEditTab)this.commonTab).defaultInteraction(index + 2, heldItem, mouseButton);
                }
            }
        }
    }

    @Override
    public void onTradeButtonOutputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trade instanceof ItemTradeData) {
            ItemTradeData t = (ItemTradeData)trade;
            ItemStack heldItem = this.menu.m_142621_();
            if (t.isSale() || t.isBarter()) {
                if (this.selection != index && heldItem.m_41619_()) {
                    this.changeSelection(index);
                } else {
                    ((ItemTradeEditTab)this.commonTab).defaultInteraction(index, heldItem, mouseButton);
                }
            } else if (t.isPurchase()) {
                this.changeSelection(-1);
            }
        }
    }

    private void changeSelection(int newSelection) {
        this.selection = newSelection;
        if (this.selection == -1) {
            this.priceSelection.setCoinValue(this.getTrade().getCost());
        }
        if (this.selection >= 0 && this.selection < 2) {
            this.itemEdit.refreshSearch();
            this.customNameInput.m_94144_(((ItemTradeEditTab)this.commonTab).getTrade().getCustomName(this.selection));
        }
        if (this.selection >= 2) {
            this.itemEdit.refreshSearch();
        }
    }

    @Override
    public void onTradeButtonInteraction(TraderData trader, TradeData trade, int localMouseX, int localMouseY, int mouseButton) {
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.onInteractionClick((int)mouseX, (int)mouseY, button, this);
        return false;
    }

    public void onValueChanged(CoinValue value) {
        ((ItemTradeEditTab)this.commonTab).setPrice(value);
    }

    @Override
    public ItemTradeData getTrade() {
        return ((ItemTradeEditTab)this.commonTab).getTrade();
    }

    @Override
    public boolean restrictItemEditItems() {
        return this.selection < 2;
    }

    @Override
    public void onItemClicked(ItemStack item) {
        ((ItemTradeEditTab)this.commonTab).setSelectedItem(this.selection, item);
    }

    private void ToggleTradeType(EasyButton button) {
        if (this.getTrade() != null) {
            ((ItemTradeEditTab)this.commonTab).setType(this.getTrade().getTradeType().next());
            this.itemEdit.refreshSearch();
        }
    }

    private void ToggleNBTEnforcement(EasyButton button) {
        if (this.getTrade() != null) {
            ((ItemTradeEditTab)this.commonTab).setNBTEnforced(this.selection, !this.getTrade().getEnforceNBT(this.selection));
        }
    }
}

