/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionTradeCancelTab;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AuctionTradeCancelClientTab
extends TraderStorageClientTab<AuctionTradeCancelTab> {
    TradeButton tradeDisplay;
    EasyButton buttonCancelPlayerGive;
    EasyButton buttonCancelStorageGive;

    public AuctionTradeCancelClientTab(Object screen, AuctionTradeCancelTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.BLANK;
    }

    public MutableComponent getTooltip() {
        return EasyText.empty();
    }

    @Override
    public boolean tabButtonVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.tradeDisplay = this.addChild(new TradeButton(this.menu::getContext, ((AuctionTradeCancelTab)this.commonTab)::getTrade, b -> {}));
        this.tradeDisplay.setPosition(screenArea.pos.offset(screenArea.width / 2 - 47, 17));
        this.buttonCancelPlayerGive = this.addChild(new EasyTextButton(screenArea.pos.offset(40, 60), screenArea.width - 80, 20, (Component)EasyText.translatable("button.lightmanscurrency.auction.cancel.self", new Object[0]), b -> ((AuctionTradeCancelTab)this.commonTab).cancelAuction(true)).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.cancel.self", new Object[0]), 160)));
        this.buttonCancelStorageGive = this.addChild(new EasyTextButton(screenArea.pos.offset(40, 85), screenArea.width - 80, 20, (Component)EasyText.translatable("button.lightmanscurrency.auction.cancel.storage", new Object[0]), b -> ((AuctionTradeCancelTab)this.commonTab).cancelAuction(false)).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.cancel.storage", new Object[0]), 160)));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TextRenderUtil.drawCenteredText(gui, (Component)EasyText.translatable("tooltip.lightmanscurrency.auction.cancel", new Object[0]), this.screen.getXSize() / 2, 50, 0x404040);
    }

    @Override
    public void tick() {
        AuctionTradeData trade = ((AuctionTradeCancelTab)this.commonTab).getTrade();
        if (trade == null || !trade.isOwner(this.menu.player) || !trade.isValid()) {
            this.screen.changeTab(0);
        }
    }

    @Override
    public void receiveSelfMessage(CompoundTag message) {
        if (message.m_128441_("TradeIndex")) {
            ((AuctionTradeCancelTab)this.commonTab).setTradeIndex(message.m_128451_("TradeIndex"));
        }
    }

    @Override
    public void receiveServerMessage(CompoundTag message) {
        if (message.m_128441_("CancelSuccess")) {
            this.screen.changeTab(0);
        }
    }
}

