/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.taxes.ITaxInfoInteractable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.taxes.TaxInfoWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TaxInfoTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TaxInfoClientTab
extends TraderStorageClientTab<TaxInfoTab>
implements IScrollable,
ITaxInfoInteractable {
    public static final int DISPLAY_ENTRIES = 4;
    private int scroll = 0;

    public TaxInfoClientTab(Object screen, TaxInfoTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TAXES;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.trader.tax_info", new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        for (int i = 0; i < 4; ++i) {
            int index = i;
            this.addChild(new TaxInfoWidget(screenArea.pos.offset(15, 30 * i + 20), () -> this.getEntryOfIndex(index), this));
        }
        this.addChild(new ScrollListener(screenArea.ofSize(screenArea.width, 120).atPosition(screenArea.pos.offset(0, 10)), this));
        this.addChild(new ScrollBarWidget(screenArea.pos.offset(191, 20), 120, this));
        this.menu.SetCoinSlotsActive(false);
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.getTrader();
        if (trader != null) {
            TextRenderUtil.drawCenteredText(gui, (Component)EasyText.translatable("tooltip.lightmanscurrency.trader.tax_info.total_rate", trader.getTotalTaxPercentage()), this.screen.getXSize() / 2, 6, 0x404040);
            if (trader.getPossibleTaxes().size() == 0) {
                TextRenderUtil.drawCenteredMultilineText(gui, (Component)EasyText.translatable("tooltip.lightmanscurrency.trader.tax_info.no_tax_collectors", new Object[0]), 10, this.screen.getXSize() - 20, 60, 0x404040);
            }
        }
    }

    private List<TaxEntry> getAllEntries() {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            return trader.getPossibleTaxes();
        }
        return new ArrayList<TaxEntry>();
    }

    @Nullable
    private TaxEntry getEntryOfIndex(int index) {
        List<TaxEntry> entries = this.getAllEntries();
        if ((index += this.scroll) < 0 || index >= entries.size()) {
            return null;
        }
        return entries.get(index);
    }

    @Override
    protected void closeAction() {
        this.menu.SetCoinSlotsActive(true);
    }

    @Override
    public void tick() {
        this.validateScroll();
    }

    @Override
    @Nullable
    public TraderData getTrader() {
        return this.menu.getTrader();
    }

    @Override
    public boolean canPlayerForceIgnore() {
        return CommandLCAdmin.isAdminPlayer(this.menu.player);
    }

    @Override
    public void AcceptTaxCollector(long taxEntryID) {
        ((TaxInfoTab)this.commonTab).AcceptTaxes(taxEntryID);
    }

    @Override
    public void ForceIgnoreTaxCollector(long taxEntryID) {
        ((TaxInfoTab)this.commonTab).ForceIgnoreTaxCollector(taxEntryID);
    }

    @Override
    public void PardonIgnoredTaxCollector(long taxEntryID) {
        ((TaxInfoTab)this.commonTab).PardonIgnoredTaxCollector(taxEntryID);
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(4, this.getAllEntries().size());
    }
}

