/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;

public class BasicTradeEditClientTab<T extends BasicTradeEditTab>
extends TraderStorageClientTab<T>
implements TradeButtonArea.InteractionConsumer {
    TradeButtonArea tradeDisplay;
    EasyButton buttonAddTrade;
    EasyButton buttonRemoveTrade;

    public BasicTradeEditClientTab(Object screen, T commonTab) {
        super(screen, commonTab);
        ((BasicTradeEditTab)this.commonTab).setClientHandler(((TraderStorageScreen)screen)::selfMessage);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADELIST;
    }

    @Override
    public Component getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.trader.edit_trades", new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.tradeDisplay = this.addChild(new TradeButtonArea(this.menu.traderSource, t -> this.menu.getContext(), screenArea.x + 3, screenArea.y + 17, screenArea.width - 6, 100, (t1, t2) -> {}, this.menu.getTrader() == null ? TradeButtonArea.FILTER_ANY : this.menu.getTrader().getStorageDisplayFilter(this.menu)));
        this.tradeDisplay.setInteractionConsumer(this);
        this.tradeDisplay.withTitle(screenArea.pos.offset(6, 6), screenArea.width - (this.renderAddRemoveButtons() ? 32 : 16), true);
        this.buttonAddTrade = this.addChild(IconAndButtonUtil.plusButton(screenArea.pos.offset(screenArea.width - 25, 4), this::AddTrade));
        this.buttonRemoveTrade = this.addChild(IconAndButtonUtil.minusButton(screenArea.pos.offset(screenArea.width - 14, 4), this::RemoveTrade));
        this.tick();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    private boolean renderAddRemoveButtons() {
        if (this.menu.getTrader() != null) {
            return this.menu.getTrader().canEditTradeCount();
        }
        return false;
    }

    @Override
    public void tick() {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            this.buttonAddTrade.f_93624_ = this.buttonRemoveTrade.f_93624_ = trader.canEditTradeCount();
            this.buttonAddTrade.f_93623_ = trader.getTradeCount() < trader.getMaxTradeCount();
            this.buttonRemoveTrade.f_93623_ = trader.getTradeCount() > 1;
        } else {
            this.buttonRemoveTrade.f_93624_ = false;
            this.buttonAddTrade.f_93624_ = false;
        }
    }

    @Override
    public void onTradeButtonInputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trader.hasPermission(this.menu.player, "editTrades")) {
            trade.onInputDisplayInteraction((BasicTradeEditTab)this.commonTab, this.screen::selfMessage, index, mouseButton, this.menu.m_142621_());
        } else {
            Permissions.PermissionWarning(this.menu.player, "edit trade", "editTrades");
        }
    }

    @Override
    public void onTradeButtonOutputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trader.hasPermission(this.menu.player, "editTrades")) {
            trade.onOutputDisplayInteraction((BasicTradeEditTab)this.commonTab, this.screen::selfMessage, index, mouseButton, this.menu.m_142621_());
        } else {
            Permissions.PermissionWarning(this.menu.player, "edit trade", "editTrades");
        }
    }

    @Override
    public void onTradeButtonInteraction(TraderData trader, TradeData trade, int localMouseX, int localMouseY, int mouseButton) {
        if (trader.hasPermission(this.menu.player, "editTrades")) {
            trade.onInteraction((BasicTradeEditTab)this.commonTab, this.screen::selfMessage, localMouseX, localMouseY, mouseButton, this.menu.m_142621_());
        } else {
            Permissions.PermissionWarning(this.menu.player, "edit trade", "editTrades");
        }
    }

    private void AddTrade(EasyButton button) {
        ((BasicTradeEditTab)this.commonTab).addTrade();
    }

    private void RemoveTrade(EasyButton button) {
        ((BasicTradeEditTab)this.commonTab).removeTrade();
    }
}

