/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NetworkTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.NetworkTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.TraderSelectTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TraderSelectClientTab
extends TraderInterfaceClientTab<TraderSelectTab>
implements IScrollable {
    EditBox searchField;
    ScrollBarWidget scrollBar;
    List<NetworkTraderButton> traderButtons;
    private int scroll;
    private List<TraderData> filteredTraderList = new ArrayList<TraderData>();
    String previousInput = "";

    public TraderSelectClientTab(TraderInterfaceScreen screen, TraderSelectTab tab) {
        super(screen, tab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.TERMINAL);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.interface.trader", new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    private List<TraderData> traderList() {
        List<TraderData> traderList = this.filterTraders(TraderSaveData.GetAllTerminalTraders(true));
        traderList.sort(NetworkTerminalScreen.TERMINAL_SORTER);
        return traderList;
    }

    private List<TraderData> filterTraders(List<TraderData> allTraders) {
        ArrayList<TraderData> traders = new ArrayList<TraderData>();
        TraderInterfaceBlockEntity be = this.menu.getBE();
        if (be == null) {
            return traders;
        }
        TraderInterfaceBlockEntity.InteractionType interaction = be.getInteractionType();
        for (TraderData trader : allTraders) {
            if (!be.validTraderType(trader) || (!interaction.trades || !trader.hasValidTrade()) && (!interaction.requiresPermissions || !be.hasTraderPermissions(trader))) continue;
            traders.add(trader);
        }
        return traders;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.searchField = this.addChild(new EditBox(this.getFont(), screenArea.x + 43, screenArea.y + 6, 101, 9, (Component)EasyText.translatable("gui.lightmanscurrency.terminal.search", new Object[0])));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        if (firstOpen) {
            this.previousInput = "";
        } else {
            this.searchField.m_94144_(this.previousInput);
        }
        this.initTraderButtons(screenArea.pos);
        this.scrollBar = this.addChild(new ScrollBarWidget(screenArea.pos.offset(176, 18), 120, this));
        this.tick();
        this.updateTraderList();
        TraderData selectedTrader = this.menu.getBE().getTrader();
        if (selectedTrader != null) {
            this.scroll = this.scrollOf(selectedTrader);
            this.updateTraderButtons();
        }
        this.addChild(new ScrollListener(0, 0, this.screen.f_96543_, this.screen.f_96544_, this));
    }

    private void initTraderButtons(ScreenPosition corner) {
        this.traderButtons = new ArrayList<NetworkTraderButton>();
        for (int y = 0; y < 4; ++y) {
            NetworkTraderButton newButton = this.addChild(new NetworkTraderButton(corner.offset(30, 18 + y * 30), this::SelectTrader));
            this.traderButtons.add(newButton);
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TraderInterfaceScreen.GUI_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.blit(TraderInterfaceScreen.GUI_TEXTURE, 28, 4, 0, 236, 117, 12);
    }

    @Override
    public void tick() {
        this.searchField.m_94120_();
        for (NetworkTraderButton button : this.traderButtons) {
            button.selected = button.getData() != null && button.getData() == ((TraderInterfaceMenu)this.screen.m_6262_()).getBE().getTrader();
        }
        if (!Objects.equals(this.previousInput, this.searchField.m_94155_())) {
            this.previousInput = this.searchField.m_94155_();
            this.updateTraderList();
        }
    }

    private void SelectTrader(EasyButton button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            long traderID = this.filteredTraderList.get(index).getID();
            ((TraderSelectTab)this.commonTab).setTrader(traderID);
        }
    }

    private int getTraderIndex(EasyButton button) {
        if (button instanceof NetworkTraderButton) {
            if (!this.traderButtons.contains((Object)button)) {
                return -1;
            }
            int index = this.traderButtons.indexOf((Object)button);
            return index += this.scroll;
        }
        return -1;
    }

    @Override
    public int getMaxScroll() {
        return Math.max(this.filteredTraderList.size() - this.traderButtons.size(), 0);
    }

    private int scrollOf(TraderData trader) {
        if (this.filteredTraderList != null) {
            int index = this.filteredTraderList.indexOf(trader);
            if (index >= 0) {
                return Math.min(index, this.getMaxScroll());
            }
            return this.scroll;
        }
        return this.scroll;
    }

    private void updateTraderList() {
        this.filteredTraderList = TraderSearchFilter.FilterTraders(this.traderList(), this.searchField.m_94155_());
        this.updateTraderButtons();
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    private void updateTraderButtons() {
        int startIndex = this.scroll;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = Math.min(newScroll, this.getMaxScroll());
        this.updateTraderButtons();
    }

    private boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (this.scroll < this.getMaxScroll()) {
                this.setScroll(this.scroll + 1);
            }
        } else if (delta > 0.0 && this.scroll > 0) {
            this.setScroll(this.scroll - 1);
        }
        return false;
    }
}

