/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.common;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageExecuteTrade;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.Slot;

public class TraderInteractionTab
extends TraderClientTab {
    TradeButtonArea tradeDisplay;
    private static long lastPress = 0L;

    public TraderInteractionTab(TraderScreen screen) {
        super(screen);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.tradeDisplay = this.addChild(new TradeButtonArea(this.menu.traderSource, this.menu::getContext, screenArea.x + 3, screenArea.y + 17, screenArea.width - 6, 100, this::OnButtonPress, TradeButtonArea.FILTER_VALID));
        this.tradeDisplay.withTitle(screenArea.pos.offset(8, 6), screenArea.width - 16, true);
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TradeButton hoveredButton = this.tradeDisplay.getHoveredButton(gui.mousePos);
        if (hoveredButton != null) {
            gui.resetColor();
            TradeData trade = hoveredButton.getTrade();
            TradeContext context = hoveredButton.getContext();
            List<Integer> relevantSlots = trade.getRelevantInventorySlots(context, (NonNullList<Slot>)this.menu.f_38839_);
            for (int s : relevantSlots) {
                if (s < 0 || s >= this.menu.f_38839_.size()) continue;
                Slot slot = (Slot)this.menu.f_38839_.get(s);
                gui.blit(TraderScreen.GUI_TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, this.screen.getXSize(), 24, 18, 18);
            }
        }
    }

    private void OnButtonPress(TraderData trader, TradeData trade) {
        if (trader == null || trade == null) {
            return;
        }
        if (TimeUtil.compareTime(10L, lastPress)) {
            return;
        }
        lastPress = TimeUtil.getCurrentTime();
        ITraderSource ts = this.menu.traderSource.get();
        if (ts == null) {
            this.menu.player.m_6915_();
            return;
        }
        List<TraderData> traders = ts.getTraders();
        int ti = traders.indexOf(trader);
        if (ti < 0) {
            return;
        }
        TraderData t = traders.get(ti);
        if (t == null) {
            return;
        }
        int tradeIndex = t.getTradeData().indexOf(trade);
        if (tradeIndex < 0) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageExecuteTrade(ti, tradeIndex));
    }
}

