/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.TeamBankReference;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferTeam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class TransferTab
extends ATMTab {
    public static final int RESPONSE_DURATION = 100;
    private int responseTimer = 0;
    CoinValueInput amountWidget;
    EditBox playerInput;
    TeamSelectWidget teamSelection;
    IconButton buttonToggleMode;
    EasyButton buttonTransfer;
    long selectedTeam = -1L;
    boolean playerMode = true;

    public TransferTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORE_COINS;
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.atm.transfer", new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        SimpleSlot.SetInactive(this.screen.m_6262_());
        this.responseTimer = 0;
        if (firstOpen) {
            ((ATMMenu)this.screen.m_6262_()).clearMessage();
        }
        this.amountWidget = this.addChild(new CoinValueInput(screenArea.pos, (Component)EasyText.translatable("gui.lightmanscurrency.bank.transfertip", new Object[0]), CoinValue.EMPTY, this.getFont(), CoinValueInput.EMPTY_CONSUMER));
        this.amountWidget.allowFreeToggle = false;
        this.amountWidget.drawBG = false;
        this.buttonToggleMode = this.addChild(new IconButton(screenArea.pos.offset(this.screen.f_96543_ - 30, 64), this::ToggleMode, (NonNullSupplier<IconData>)((NonNullSupplier)() -> this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconAndButtonUtil.ICON_ALEX_HEAD)).withAddons(EasyAddonHelper.toggleTooltip((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.playerMode), (Component)EasyText.translatable("tooltip.lightmanscurrency.atm.transfer.mode.team", new Object[0]), (Component)EasyText.translatable("tooltip.lightmanscurrency.atm.transfer.mode.player", new Object[0]))));
        this.playerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 104, screenArea.width - 20, 20, (Component)Component.m_237119_()));
        this.playerInput.f_93624_ = this.playerMode;
        this.teamSelection = this.addChild(new TeamSelectWidget(screenArea.pos.offset(10, 84), 2, TeamButton.Size.NORMAL, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.f_93624_ = !this.playerMode;
        this.buttonTransfer = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 126), screenArea.width - 20, 20, (NonNullSupplier<Component>)((NonNullSupplier)() -> EasyText.translatable(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team", new Object[0])), this::PressTransfer));
        this.buttonTransfer.f_93623_ = false;
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        BankReference source = ((ATMMenu)this.screen.m_6262_()).getBankAccountReference();
        Team blockTeam = null;
        if (source instanceof TeamBankReference) {
            TeamBankReference teamBankReference = (TeamBankReference)source;
            blockTeam = TeamSaveData.GetTeam(true, teamBankReference.teamID);
        }
        for (Team team : TeamSaveData.GetAllTeams(true)) {
            if (!team.hasBankAccount() || team == blockTeam) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.selectedTeam >= 0L) {
            return TeamSaveData.GetTeam(true, this.selectedTeam);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            if (team.getID() == this.selectedTeam) {
                return;
            }
            this.selectedTeam = team.getID();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void PressTransfer(EasyButton button) {
        if (this.playerMode) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankTransferPlayer(this.playerInput.m_94155_(), this.amountWidget.getCoinValue()));
            this.playerInput.m_94144_("");
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        } else if (this.selectedTeam >= 0L) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankTransferTeam(this.selectedTeam, this.amountWidget.getCoinValue()));
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        }
    }

    private void ToggleMode(EasyButton button) {
        this.playerMode = !this.playerMode;
        this.buttonTransfer.m_93666_((Component)Component.m_237115_((String)(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team")));
        this.teamSelection.f_93624_ = !this.playerMode;
        this.playerInput.f_93624_ = this.playerMode;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.hideCoinSlots(gui);
        MutableComponent balance = ((ATMMenu)this.screen.m_6262_()).getBankAccount() == null ? Component.m_237115_((String)"gui.lightmanscurrency.bank.null") : Component.m_237110_((String)"gui.lightmanscurrency.bank.balance", (Object[])new Object[]{((ATMMenu)this.screen.m_6262_()).getBankAccount().getCoinStorage().getString("0")});
        gui.drawString((Component)balance, 8, 72, 0x404040);
        if (this.hasMessage()) {
            TextRenderUtil.drawCenteredMultilineText(gui, (Component)this.getMessage(), 2, this.screen.getXSize() - 4, 5, 0x404040);
            this.amountWidget.f_93624_ = false;
        } else {
            this.amountWidget.f_93624_ = true;
        }
    }

    @Override
    public void tick() {
        if (this.playerMode) {
            this.buttonTransfer.f_93623_ = !this.playerInput.m_94155_().isBlank() && this.amountWidget.getCoinValue().isValid();
        } else {
            Team team = this.selectedTeam();
            boolean bl = this.buttonTransfer.f_93623_ = team != null && team.hasBankAccount() && this.amountWidget.getCoinValue().isValid();
        }
        if (this.hasMessage()) {
            ++this.responseTimer;
            if (this.responseTimer >= 100) {
                this.responseTimer = 0;
                ((ATMMenu)this.screen.m_6262_()).clearMessage();
            }
        }
    }

    private boolean hasMessage() {
        return ((ATMMenu)this.screen.m_6262_()).hasTransferMessage();
    }

    private MutableComponent getMessage() {
        return ((ATMMenu)this.screen.m_6262_()).getTransferMessage();
    }

    @Override
    public void closeAction() {
        SimpleSlot.SetActive(this.screen.m_6262_());
        this.responseTimer = 0;
        ((ATMMenu)this.screen.m_6262_()).clearMessage();
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.playerMode;
    }
}

