/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.PlayerTradeMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.playertrading.CMessagePlayerTradeInteraction;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class PlayerTradeScreen
extends EasyMenuScreen<PlayerTradeMenu> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/player_trading.png");
    private CoinValueInput valueInput;
    private EasyButton buttonPropose;
    private EasyButton buttonAccept;

    private void setShaderColorForState(@Nonnull EasyGuiGraphics gui, int state) {
        switch (state) {
            case 1: {
                gui.setColor(0.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                gui.setColor(0.0f, 1.0f, 0.0f);
                break;
            }
            default: {
                gui.setColor(0.54509807f, 0.54509807f, 0.54509807f);
            }
        }
    }

    public PlayerTradeScreen(PlayerTradeMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(176, 291);
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        gui.blit(GUI_TEXTURE, 0, 69, 0, 0, this.getXSize(), this.getYSize() - 69);
        this.setShaderColorForState(gui, ((PlayerTradeMenu)this.f_97732_).myState());
        gui.blit(GUI_TEXTURE, 77, 119, this.getXSize(), 0, 22, 15);
        this.setShaderColorForState(gui, ((PlayerTradeMenu)this.f_97732_).otherState());
        gui.blit(GUI_TEXTURE, 77, 134, this.getXSize(), 15, 22, 15);
        gui.resetColor();
        Component leftName = ((PlayerTradeMenu)this.f_97732_).isHost() ? ((PlayerTradeMenu)this.f_97732_).getTradeData().getHostName() : ((PlayerTradeMenu)this.f_97732_).getTradeData().getGuestName();
        Component rightName = ((PlayerTradeMenu)this.f_97732_).isHost() ? ((PlayerTradeMenu)this.f_97732_).getTradeData().getGuestName() : ((PlayerTradeMenu)this.f_97732_).getTradeData().getHostName();
        gui.drawString(leftName, 8, 75, 0x404040);
        gui.drawString(rightName, this.getXSize() - 8 - this.f_96547_.m_92852_((FormattedText)rightName), 75, 0x404040);
        leftName = ((PlayerTradeMenu)this.f_97732_).isHost() ? ((PlayerTradeMenu)this.f_97732_).getTradeData().getHostMoney().getComponent() : ((PlayerTradeMenu)this.f_97732_).getTradeData().getGuestMoney().getComponent();
        rightName = ((PlayerTradeMenu)this.f_97732_).isHost() ? ((PlayerTradeMenu)this.f_97732_).getTradeData().getGuestMoney().getComponent() : ((PlayerTradeMenu)this.f_97732_).getTradeData().getHostMoney().getComponent();
        gui.drawString(leftName, 8, 85, 0x404040);
        gui.drawString(rightName, this.getXSize() - 8 - this.f_96547_.m_92852_((FormattedText)rightName), 85, 0x404040);
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.valueInput = this.addChild(new CoinValueInput(screenArea.pos, (Component)Component.m_237119_(), CoinValue.EMPTY, this.f_96547_, this::onValueChanged));
        this.valueInput.allowFreeToggle = false;
        this.buttonPropose = this.addChild(new EasyTextButton(screenArea.pos.offset(8, 179), 70, 20, (Component)EasyText.translatable("gui.lightmanscurrency.button.player_trading.propose", new Object[0]), this::OnPropose));
        this.buttonAccept = this.addChild(new EasyTextButton(screenArea.pos.offset(98, 179), 70, 20, (Component)EasyText.translatable("gui.lightmanscurrency.button.player_trading.accept", new Object[0]), this::OnAccept));
        this.buttonAccept.f_93623_ = false;
    }

    @Override
    protected void screenTick() {
        int myState = ((PlayerTradeMenu)this.f_97732_).myState();
        int otherState = ((PlayerTradeMenu)this.f_97732_).otherState();
        this.valueInput.f_93623_ = myState < 1;
        this.buttonPropose.f_93623_ = myState < 2;
        this.buttonPropose.m_93666_((Component)EasyText.translatable(myState <= 0 ? "gui.lightmanscurrency.button.player_trading.propose" : "gui.lightmanscurrency.button.player_trading.cancel", new Object[0]));
        this.buttonAccept.f_93623_ = myState > 0 && otherState > 0;
        this.buttonAccept.m_93666_((Component)EasyText.translatable(myState <= 1 ? "gui.lightmanscurrency.button.player_trading.accept" : "gui.lightmanscurrency.button.player_trading.cancel", new Object[0]));
    }

    private void onValueChanged(CoinValue newValue) {
        CompoundTag message = new CompoundTag();
        CoinValue availableFunds = ((PlayerTradeMenu)this.f_97732_).getAvailableFunds();
        if (newValue.getValueNumber() > availableFunds.getValueNumber()) {
            newValue = availableFunds;
            this.valueInput.setCoinValue(newValue);
        }
        message.m_128365_("ChangeMoney", (Tag)newValue.save());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CMessagePlayerTradeInteraction(((PlayerTradeMenu)this.f_97732_).tradeID, message));
    }

    private void OnPropose(EasyButton button) {
        CompoundTag message = new CompoundTag();
        message.m_128379_("TogglePropose", true);
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CMessagePlayerTradeInteraction(((PlayerTradeMenu)this.f_97732_).tradeID, message));
    }

    private void OnAccept(EasyButton button) {
        CompoundTag message = new CompoundTag();
        message.m_128379_("ToggleActive", true);
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CMessagePlayerTradeInteraction(((PlayerTradeMenu)this.f_97732_).tradeID, message));
    }
}

