/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.lightman314.lightmanscurrency.client.data.ClientNotificationData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.notifications.MarkAsSeenButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.notifications.NotificationTabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.notifications.MessageFlagNotificationsSeen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.common.util.NonNullSupplier;

public class NotificationScreen
extends EasyScreen
implements IScrollable {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/notifications.png");
    private static final int SCREEN_WIDTH = 200;
    private static final int SCREEN_HEIGHT = 200;
    public final int TABS_PER_PAGE = 8;
    public final int NOTIFICATIONS_PER_PAGE = 8;
    public final int NOTIFICATION_HEIGHT = 22;
    List<NotificationTabButton> tabButtons;
    int tabScroll = 0;
    NotificationCategory selectedCategory = NotificationCategory.GENERAL;
    ScrollBarWidget notificationScroller = null;
    EasyButton buttonMarkAsSeen;
    int notificationScroll = 0;
    private Component cachedTooltip = null;

    public final NotificationData getNotifications() {
        return ClientNotificationData.GetNotifications();
    }

    public NotificationScreen() {
        this.resize(225, 200);
    }

    public List<NotificationCategory> getCategories() {
        ArrayList categories = Lists.newArrayList((Object[])new NotificationCategory[]{NotificationCategory.GENERAL});
        categories.addAll(this.getNotifications().getCategories().stream().filter(cat -> cat != NotificationCategory.GENERAL).toList());
        return categories;
    }

    public void reinit() {
        this.m_169413_();
        this.validateSelectedCategory();
        this.m_7856_();
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.tabButtons = new ArrayList<NotificationTabButton>();
        for (NotificationCategory cat : this.getCategories()) {
            this.tabButtons.add(this.addChild(new NotificationTabButton(this::SelectTab, (NonNullSupplier<NotificationData>)((NonNullSupplier)this::getNotifications), cat)));
        }
        this.positionTabButtons();
        ScreenPosition screenPosition = screenArea.pos.offset(screenArea.width - 15, 15);
        Objects.requireNonNull(this);
        this.notificationScroller = this.addChild(new ScrollBarWidget(screenPosition, 8 * this.NOTIFICATION_HEIGHT, this));
        this.buttonMarkAsSeen = this.addChild(new MarkAsSeenButton(screenArea.x + screenArea.width - 15, screenArea.y + 4, (Component)EasyText.translatable("gui.button.notifications.mark_read", new Object[0]), this::markAsRead).withAddons(EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.getNotifications().unseenNotification(this.selectedCategory)))));
    }

    private void validateSelectedCategory() {
        List<NotificationCategory> categories = this.getCategories();
        boolean categoryFound = false;
        for (int i = 0; i < categories.size() && !categoryFound; ++i) {
            if (!categories.get(i).matches(this.selectedCategory)) continue;
            categoryFound = true;
        }
        if (!categoryFound || this.selectedCategory == null) {
            this.selectedCategory = NotificationCategory.GENERAL;
        }
    }

    private void positionTabButtons() {
        int startIndex = this.tabScroll = Math.min(this.tabScroll, this.getMaxTabScroll());
        ScreenPosition pos = this.getCorner();
        List<NotificationCategory> categories = this.getCategories();
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            TabButton tab = this.tabButtons.get(i);
            if (i >= startIndex && i < startIndex + 8) {
                tab.f_93624_ = true;
                tab.reposition(pos, 3);
                tab.f_93623_ = i < categories.size() ? !categories.get(i).matches(this.selectedCategory) : true;
                pos = pos.offset(0, 25);
                continue;
            }
            tab.f_93624_ = false;
        }
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        int screenLeft = 25;
        gui.resetColor();
        gui.blit(GUI_TEXTURE, screenLeft, 0, 0, 0, 200, this.getYSize());
        this.notificationScroll = Math.min(this.notificationScroll, this.getMaxNotificationScroll());
        List<Notification> notifications = this.getNotifications().getNotifications(this.selectedCategory);
        this.cachedTooltip = null;
        int index = this.notificationScroll;
        for (int y = 0; y < 8 && index < notifications.size(); ++y) {
            MutableComponent message;
            List lines;
            Notification not = notifications.get(index++);
            int yPos = 15 + y * 22;
            gui.resetColor();
            int vPos = not.wasSeen() ? this.getYSize() : this.getYSize() + 22;
            int textColor = not.wasSeen() ? 0xFFFFFF : 0;
            gui.blit(GUI_TEXTURE, screenLeft + 15, yPos, 0, vPos, 170, 22);
            int textXPos = screenLeft + 17;
            int textWidth = 166;
            if (not.getCount() > 1) {
                String countText = String.valueOf(not.getCount());
                int quantityWidth = this.f_96547_.m_92895_(countText);
                gui.blit(GUI_TEXTURE, screenLeft + 16 + quantityWidth, yPos, 170, vPos, 3, 22);
                Objects.requireNonNull(this.f_96547_);
                gui.drawString(countText, textXPos, yPos + 11 - 9 / 2, textColor);
                textXPos += quantityWidth + 2;
                textWidth -= quantityWidth + 2;
            }
            if ((lines = this.f_96547_.m_92923_((FormattedText)(message = this.selectedCategory == NotificationCategory.GENERAL ? not.getGeneralMessage() : not.getMessage()), textWidth)).size() == 1) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(0);
                Objects.requireNonNull(this.f_96547_);
                gui.drawString(formattedCharSequence, textXPos, yPos + 11 - 9 / 2, textColor);
                continue;
            }
            for (int l = 0; l < lines.size() && l < 2; ++l) {
                gui.drawString((FormattedCharSequence)lines.get(l), textXPos, yPos + 2 + l * 10, textColor);
            }
            if (this.cachedTooltip != null || !this.getCorner().offset(screenLeft + 15, yPos).isMouseInArea(gui.mousePos, 170, 22)) continue;
            if (lines.size() > 2) {
                if (not.hasTimeStamp()) {
                    this.cachedTooltip = EasyText.empty().m_7220_(not.getTimeStampMessage()).m_7220_((Component)EasyText.literal("\n")).m_7220_((Component)message);
                    continue;
                }
                this.cachedTooltip = message;
                continue;
            }
            if (!not.hasTimeStamp()) continue;
            this.cachedTooltip = not.getTimeStampMessage();
        }
    }

    @Override
    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        if (this.cachedTooltip != null) {
            gui.renderTooltip(gui.font.m_92923_((FormattedText)this.cachedTooltip, 170));
        }
    }

    private void SelectTab(EasyButton button) {
        NotificationCategory newCategory;
        List<NotificationCategory> categories;
        int tabIndex = -1;
        if (button instanceof NotificationTabButton) {
            tabIndex = this.tabButtons.indexOf((Object)button);
        }
        if (tabIndex >= 0 && tabIndex < (categories = this.getCategories()).size() && !(newCategory = categories.get(tabIndex)).matches(this.selectedCategory)) {
            this.selectedCategory = newCategory;
            this.notificationScroll = 0;
            this.positionTabButtons();
        }
    }

    public int getMaxTabScroll() {
        return Math.max(0, this.tabButtons.size() - 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tabScrolled(double delta) {
        if (delta < 0.0) {
            if (this.tabScroll >= this.getMaxTabScroll()) return false;
            ++this.tabScroll;
            this.positionTabButtons();
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.tabScroll <= 0) return false;
            --this.tabScroll;
            this.positionTabButtons();
        }
        return true;
    }

    public int getMaxNotificationScroll() {
        return Math.max(0, this.getNotifications().getNotifications(this.selectedCategory).size() - 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean notificationScrolled(double delta) {
        if (delta < 0.0) {
            if (this.notificationScroll >= this.getMaxNotificationScroll()) return false;
            ++this.notificationScroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.notificationScroll <= 0) return false;
            --this.notificationScroll;
        }
        return true;
    }

    public void markAsRead(EasyButton button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageFlagNotificationsSeen(this.selectedCategory));
    }

    @Override
    public int currentScroll() {
        return this.notificationScroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.notificationScroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return this.getMaxNotificationScroll();
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.getCorner().offset(25, 0).isMouseInArea(mouseX, mouseY, this.getXSize() - 25, this.getYSize())) {
            if (this.notificationScrolled(delta)) {
                return true;
            }
            return super.m_6050_(mouseX, mouseY, delta);
        }
        if (this.tabScrolled(delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int mods) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)key, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_7933_(key, scanCode, mods);
    }
}

