/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.NetworkTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.TerminalMenu;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenTrades;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetworkTerminalScreen
extends EasyMenuScreen<TerminalMenu>
implements IScrollable {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/trader_selection.png");
    public static final Comparator<TraderData> TERMINAL_SORTER = new TraderSorter(true, true, true);
    public static final Comparator<TraderData> NAME_ONLY_SORTER = new TraderSorter(false, false, false);
    private EditBox searchField;
    private static int scroll = 0;
    ScrollBarWidget scrollBar;
    List<NetworkTraderButton> traderButtons;
    private List<TraderData> filteredTraderList = new ArrayList<TraderData>();

    private List<TraderData> traderList() {
        List<TraderData> traderList = TraderSaveData.GetAllTerminalTraders(true);
        traderList.sort(TERMINAL_SORTER);
        return traderList;
    }

    public NetworkTerminalScreen(TerminalMenu menu, Inventory inventory, Component ignored) {
        super(menu, inventory, (Component)EasyText.translatable("block.lightmanscurrency.terminal", new Object[0]));
        this.resize(176, 187);
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.searchField = this.addChild(new EditBox(this.f_96547_, screenArea.x + 28, screenArea.y + 6, 101, 9, (Component)EasyText.translatable("gui.lightmanscurrency.terminal.search", new Object[0])));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.scrollBar = this.addChild(new ScrollBarWidget(screenArea.pos.offset(162, 17), 152, this));
        this.initTraderButtons(screenArea);
        this.m_86600_();
        this.updateTraderList();
        this.validateScroll();
    }

    public boolean m_7043_() {
        return false;
    }

    private void initTraderButtons(ScreenArea screenArea) {
        this.traderButtons = new ArrayList<NetworkTraderButton>();
        for (int y = 0; y < 5; ++y) {
            NetworkTraderButton newButton = this.addChild(new NetworkTraderButton(screenArea.pos.offset(15, 18 + y * 30), this::OpenTrader));
            this.traderButtons.add(newButton);
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
    }

    public boolean m_5534_(char c, int code) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, code)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int mods) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_7933_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return this.searchField.m_93696_() && this.searchField.m_94213_() && key != 256 || super.m_7933_(key, scanCode, mods);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.handleScrollWheel(delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void OpenTrader(EasyButton button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenTrades(this.filteredTraderList.get(index).getID()));
        }
    }

    private int getTraderIndex(EasyButton button) {
        if (button instanceof NetworkTraderButton && this.traderButtons.contains((Object)button)) {
            return this.traderButtons.indexOf((Object)button) + scroll;
        }
        return -1;
    }

    private void updateTraderList() {
        this.filteredTraderList = this.searchField.m_94155_().isBlank() ? this.traderList() : TraderSearchFilter.FilterTraders(this.traderList(), this.searchField.m_94155_());
        this.validateScroll();
        this.updateTraderButtons();
    }

    private void updateTraderButtons() {
        int startIndex = scroll;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    @Override
    public int currentScroll() {
        return scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        scroll = newScroll;
        this.updateTraderButtons();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.filteredTraderList.size() - this.traderButtons.size());
    }

    private record TraderSorter(boolean creativeAtTop, boolean emptyAtBottom, boolean auctionHousePriority) implements Comparator<TraderData>
    {
        @Override
        public int compare(TraderData a, TraderData b) {
            try {
                int sort;
                if (this.auctionHousePriority) {
                    boolean ahA = a instanceof AuctionHouseTrader;
                    boolean ahB = b instanceof AuctionHouseTrader;
                    if (ahA && !ahB) {
                        return -1;
                    }
                    if (ahB && !ahA) {
                        return 1;
                    }
                }
                if (this.emptyAtBottom) {
                    boolean emptyB;
                    boolean emptyA = !a.hasValidTrade();
                    boolean bl = emptyB = !b.hasValidTrade();
                    if (emptyA != emptyB) {
                        return emptyA ? 1 : -1;
                    }
                }
                if (this.creativeAtTop) {
                    if (a.isCreative() && !b.isCreative()) {
                        return -1;
                    }
                    if (b.isCreative() && !a.isCreative()) {
                        return 1;
                    }
                }
                if ((sort = a.getName().getString().toLowerCase().compareTo(b.getName().getString().toLowerCase())) == 0) {
                    sort = a.getOwner().getOwnerName(true).compareToIgnoreCase(b.getOwner().getOwnerName(true));
                }
                return sort;
            }
            catch (Throwable t) {
                return 0;
            }
        }
    }
}

