/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientEvents;
import io.github.lightman314.lightmanscurrency.client.ModLayerDefinitions;
import io.github.lightman314.lightmanscurrency.client.colors.SusBlockColor;
import io.github.lightman314.lightmanscurrency.client.colors.TicketColor;
import io.github.lightman314.lightmanscurrency.client.gui.overlay.WalletDisplayOverlay;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.EnchantedBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.NormalBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.entity.layers.WalletLayer;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new TicketColor(), new ItemLike[]{(ItemLike)ModItems.TICKET.get(), (ItemLike)ModItems.TICKET_PASS.get(), (ItemLike)ModItems.TICKET_MASTER.get()});
        event.register((ItemColor)new SusBlockColor.Item(), new ItemLike[]{(ItemLike)ModBlocks.SUS_JAR.get()});
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)new SusBlockColor(), new Block[]{(Block)ModBlocks.SUS_JAR.get()});
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        for (FreezerBlock block : ModBlocks.FREEZER.getAll()) {
            event.register(block.getDoorModel());
        }
        event.register(SlotMachineBlock.LIGHT_MODEL_LOCATION);
        event.register(NormalBookRenderer.MODEL_LOCATION);
        event.register(EnchantedBookRenderer.MODEL_LOCATION);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModLayerDefinitions.WALLET, WalletLayer::createLayer);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        ClientModEvents.addWalletLayer(event, "default");
        ClientModEvents.addWalletLayer(event, "slim");
    }

    private static void addWalletLayer(EntityRenderersEvent.AddLayers event, String skin) {
        LivingEntityRenderer renderer = event.getSkin(skin);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_(new WalletLayer(livingRenderer));
        }
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ClientEvents.KEY_WALLET);
        if (LightmansCurrency.isCuriosLoaded()) {
            event.register(ClientEvents.KEY_PORTABLE_TERMINAL);
        }
    }

    @SubscribeEvent
    public static void registerWalletGuiOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("wallet_hud", (IGuiOverlay)WalletDisplayOverlay.INSTANCE);
    }
}

