/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.util.ScreenUtil;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ChestCoinCollectButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.NotificationButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TeamManagerButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TraderRecoveryButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet.VisibilityToggleButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet.WalletButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessageOpenWallet;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketSetVisible;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketWalletInteraction;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT})
public class ClientEvents {
    public static final ResourceLocation WALLET_SLOT_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/wallet_slot.png");
    public static final KeyMapping KEY_WALLET = new KeyMapping("key.wallet", 86, "key.categories.inventory");
    public static final KeyMapping KEY_PORTABLE_TERMINAL = new KeyMapping("key.portable_terminal", 92, "key.categories.inventory");

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ instanceof WalletScreen && minecraft.f_91074_ != null) {
            if (event.getAction() == 1 && event.getKey() == KEY_WALLET.getKey().m_84873_()) {
                minecraft.f_91074_.m_108763_();
            }
        } else if (minecraft.f_91074_ != null && minecraft.f_91080_ == null) {
            LocalPlayer player = minecraft.f_91074_;
            if (KEY_WALLET.m_90857_()) {
                LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenWallet(-1));
                if (!LightmansCurrency.getWalletStack((Player)player).m_41619_()) {
                    minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11678_, (float)(1.25f + player.m_9236_().f_46441_.m_188501_() * 0.5f), (float)0.75f));
                    ItemStack wallet = LightmansCurrency.getWalletStack((Player)player);
                    if (!WalletItem.isEmpty(wallet)) {
                        minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)ModSounds.COINS_CLINKING.get()), (float)1.0f, (float)0.4f));
                    }
                }
            }
        }
        if (LightmansCurrency.isCuriosLoaded() && event.getAction() == 1 && event.getKey() == KEY_PORTABLE_TERMINAL.getKey().m_84873_() && LCCurios.hasPortableTerminal((LivingEntity)minecraft.f_91074_)) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenNetworkTerminal(true));
        }
    }

    @SubscribeEvent
    public static void onInventoryGuiInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            event.addListener((GuiEventListener)new NotificationButton(gui));
            event.addListener((GuiEventListener)new TeamManagerButton(gui));
            event.addListener((GuiEventListener)new TraderRecoveryButton(gui));
            Minecraft mc = Minecraft.m_91087_();
            if (LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
                return;
            }
            event.addListener((GuiEventListener)new WalletButton(gui, b -> LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenWallet(-1))));
            event.addListener((GuiEventListener)new VisibilityToggleButton(gui, ClientEvents::toggleVisibility));
        } else if (screen instanceof ContainerScreen) {
            ContainerScreen chestScreen = (ContainerScreen)screen;
            event.addListener((GuiEventListener)new ChestCoinCollectButton(chestScreen));
        }
    }

    private static void toggleVisibility(EasyButton button) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        IWalletHandler handler = WalletCapability.lazyGetWalletHandler((Entity)player);
        if (handler != null) {
            boolean nowVisible = !handler.visible();
            handler.setVisible(nowVisible);
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CPacketSetVisible(player.m_19879_(), nowVisible));
        }
    }

    @SubscribeEvent
    public static void renderInventoryScreen(ContainerScreenEvent.Render.Background event) {
        Minecraft mc = Minecraft.m_91087_();
        if (LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
            return;
        }
        AbstractContainerScreen screen = event.getContainerScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            if (screen instanceof CreativeModeInventoryScreen && !(creativeScreen = (CreativeModeInventoryScreen)screen).m_258017_()) {
                return;
            }
            IWalletHandler walletHandler = ClientEvents.getWalletHandler();
            if (walletHandler == null) {
                return;
            }
            EasyGuiGraphics gui = EasyGuiGraphics.create((ContainerScreenEvent.Render)event);
            ScreenPosition slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen).offsetScreen(screen);
            gui.resetColor();
            gui.blit(WALLET_SLOT_TEXTURE, slotPosition.x, slotPosition.y, 0, 0, 18, 18);
            ItemStack wallet = walletHandler.getWallet();
            if (wallet.m_41619_()) {
                gui.renderSlotBackground(WalletSlot.BACKGROUND, slotPosition.offset(1, 1));
            } else {
                gui.renderItem(wallet, slotPosition.offset(1, 1));
            }
            if (slotPosition.isMouseInArea(event.getMouseX(), event.getMouseY(), 16, 16)) {
                gui.renderSlotHighlight(slotPosition.offset(1, 1));
            }
        }
    }

    @SubscribeEvent
    public static void renderInventoryTooltips(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof InventoryScreen || event.getScreen() instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            AbstractContainerScreen screen = (AbstractContainerScreen)event.getScreen();
            if (!screen.m_6262_().m_142621_().m_41619_()) {
                return;
            }
            if (screen instanceof CreativeModeInventoryScreen && !(creativeScreen = (CreativeModeInventoryScreen)screen).m_258017_()) {
                return;
            }
            EasyGuiGraphics gui = EasyGuiGraphics.create((ScreenEvent.Render)event);
            NotificationButton.tryRenderTooltip(gui);
            TeamManagerButton.tryRenderTooltip(gui);
            Minecraft mc = Minecraft.m_91087_();
            if (LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
                return;
            }
            ScreenPosition slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen).offsetScreen(screen);
            if (slotPosition.isMouseInArea(event.getMouseX(), event.getMouseY(), 16, 16)) {
                ItemStack wallet;
                IWalletHandler walletHandler = ClientEvents.getWalletHandler();
                ItemStack itemStack = wallet = walletHandler == null ? ItemStack.f_41583_ : walletHandler.getWallet();
                if (!wallet.m_41619_()) {
                    gui.renderTooltip(wallet, event.getMouseX(), event.getMouseY());
                }
            }
        } else if (event.getScreen() instanceof ContainerScreen) {
            ChestCoinCollectButton.tryRenderTooltip(EasyGuiGraphics.create((ScreenEvent.Render)event), event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public static void onInventoryClick(ScreenEvent.MouseButtonPressed.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            Slot hoveredSlot;
            CreativeModeInventoryScreen creativeScreen;
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            if (gui instanceof CreativeModeInventoryScreen && !(creativeScreen = (CreativeModeInventoryScreen)gui).m_258017_()) {
                return;
            }
            ScreenPosition slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen);
            if (ClientEvents.isMouseOverWalletSlot(gui, event.getMouseX(), event.getMouseY(), slotPosition) && !ClientEvents.isMouseOverVisibilityButton(gui, event.getMouseX(), event.getMouseY(), slotPosition)) {
                ItemStack heldStack = gui.m_6262_().m_142621_().m_41777_();
                boolean shiftHeld = Screen.m_96638_() && !(gui instanceof CreativeModeInventoryScreen);
                LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CPacketWalletInteraction(-1, shiftHeld, heldStack));
                WalletCapability.WalletSlotInteraction(ClientEvents.getPlayer(), -1, shiftHeld, heldStack);
            } else if (Screen.m_96638_() && !(gui instanceof CreativeModeInventoryScreen) && (hoveredSlot = gui.getSlotUnderMouse()) != null) {
                int slotIndex;
                Player player = ClientEvents.getPlayer();
                int n = slotIndex = hoveredSlot.f_40218_ != player.m_150109_() ? -1 : hoveredSlot.m_150661_();
                if (slotIndex < 0) {
                    return;
                }
                ItemStack slotItem = player.m_150109_().m_8020_(slotIndex);
                if (WalletSlot.isValidWallet(slotItem)) {
                    ItemStack heldStack = gui.m_6262_().m_142621_().m_41777_();
                    LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CPacketWalletInteraction(slotIndex, true, heldStack));
                    WalletCapability.WalletSlotInteraction(ClientEvents.getPlayer(), slotIndex, true, heldStack);
                    event.setCanceled(true);
                }
            }
        }
    }

    private static boolean isMouseOverWalletSlot(AbstractContainerScreen<?> gui, double mouseX, double mouseY, ScreenPosition slotPosition) {
        return ScreenUtil.isMouseOver(mouseX, mouseY, slotPosition.offsetScreen(gui), 18, 18);
    }

    private static boolean isMouseOverVisibilityButton(AbstractContainerScreen<?> gui, double mouseX, double mouseY, ScreenPosition slotPosition) {
        return ScreenUtil.isMouseOver(mouseX, mouseY, slotPosition.offsetScreen(gui), 6, 6);
    }

    private static IWalletHandler getWalletHandler() {
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91074_ != null);
        return WalletCapability.lazyGetWalletHandler((Entity)mc.f_91074_);
    }

    private static Player getPlayer() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91074_;
    }

    public static ScreenPosition getWalletSlotPosition(boolean isCreative) {
        return isCreative ? Config.CLIENT.walletSlotCreative.get() : Config.CLIENT.walletSlot.get();
    }
}

