/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.base.Suppliers;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.core.groups.BundleRequestFilter;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="lightmanscurrency")
public class ModCreativeGroups {
    public static final ResourceLocation COIN_GROUP_ID = new ResourceLocation("lightmanscurrency", "coins");
    public static final ResourceLocation MACHINE_GROUP_ID = new ResourceLocation("lightmanscurrency", "machines");
    public static final ResourceLocation TRADER_GROUP_ID = new ResourceLocation("lightmanscurrency", "traders");
    public static final ResourceLocation UPGRADE_GROUP_ID = new ResourceLocation("lightmanscurrency", "upgrades");
    public static final ResourceLocation EXTRA_GROUP_ID = new ResourceLocation("lightmanscurrency", "extra");
    public static final RegistryObject<CreativeModeTab> COIN_GROUP = ModRegistries.CREATIVE_TABS.register("coins", () -> CreativeModeTab.builder().m_257941_((Component)EasyText.translatable("itemGroup.lightmanscurrency.coins", new Object[0])).m_257737_(ModCreativeGroups.ezIcon(ModBlocks.COINPILE_GOLD)).m_257501_((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModItems.COIN_COPPER);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_COPPER);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_COPPER);
        ModCreativeGroups.ezPop(p, ModItems.COIN_IRON);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_IRON);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_IRON);
        ModCreativeGroups.ezPop(p, ModItems.COIN_GOLD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_GOLD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_GOLD);
        ModCreativeGroups.ezPop(p, ModItems.COIN_EMERALD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_EMERALD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_EMERALD);
        ModCreativeGroups.ezPop(p, ModItems.COIN_DIAMOND);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_DIAMOND);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_DIAMOND);
        ModCreativeGroups.ezPop(p, ModItems.COIN_NETHERITE);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_NETHERITE);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_NETHERITE);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_COPPER);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_IRON);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_GOLD);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_EMERALD);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_DIAMOND);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_NETHERITE);
        ModCreativeGroups.ezPop(p, ModItems.TRADING_CORE);
    }).m_257652_());
    public static final RegistryObject<CreativeModeTab> MACHINE_GROUP = ModRegistries.CREATIVE_TABS.register("machines", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{COIN_GROUP_ID}).m_257941_((Component)EasyText.translatable("itemGroup.lightmanscurrency.machines", new Object[0])).m_257737_(ModCreativeGroups.ezIcon(ModBlocks.COIN_MINT)).m_257501_((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModBlocks.COIN_MINT);
        ModCreativeGroups.ezPop(p, ModBlocks.ATM);
        ModCreativeGroups.ezPop(p, ModItems.PORTABLE_ATM);
        ModCreativeGroups.ezPop(p, ModBlocks.CASH_REGISTER);
        ModCreativeGroups.ezPop(p, ModBlocks.TERMINAL);
        ModCreativeGroups.ezPop(p, ModBlocks.GEM_TERMINAL);
        ModCreativeGroups.ezPop(p, ModItems.PORTABLE_TERMINAL);
        ModCreativeGroups.ezPop(p, ModItems.PORTABLE_GEM_TERMINAL);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_TRADER_INTERFACE);
        ModCreativeGroups.ezPop(p, ModBlocks.TAX_COLLECTOR);
        ModCreativeGroups.ezPop(p, ModBlocks.AUCTION_STAND, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.TICKET_STATION);
        p.m_246342_(TicketItem.CreateMasterTicket(-1L, 0xFFFF00));
        p.m_246342_(TicketItem.CreatePass(-1L, 0xFFFF00));
        p.m_246342_(TicketItem.CreateTicket(-1L, 0xFFFF00));
        ModCreativeGroups.ezPop(p, ModItems.TICKET_STUB);
        ModCreativeGroups.ezPop(p, ModBlocks.COIN_CHEST);
        ModCreativeGroups.ezPop(p, ModBlocks.PIGGY_BANK);
        ModCreativeGroups.ezPop(p, ModBlocks.COINJAR_BLUE);
    }).m_257652_());
    public static final RegistryObject<CreativeModeTab> TRADER_GROUP = ModRegistries.CREATIVE_TABS.register("traders", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{MACHINE_GROUP_ID}).m_257941_((Component)EasyText.translatable("itemGroup.lightmanscurrency.trading", new Object[0])).m_257737_(ModCreativeGroups.ezIcon(ModBlocks.DISPLAY_CASE)).m_257501_((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModBlocks.SHELF, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.DISPLAY_CASE);
        ModCreativeGroups.ezPop(p, ModBlocks.CARD_DISPLAY, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.VENDING_MACHINE);
        ModCreativeGroups.ezPop(p, ModBlocks.FREEZER);
        ModCreativeGroups.ezPop(p, ModBlocks.VENDING_MACHINE_LARGE);
        ModCreativeGroups.ezPop(p, ModBlocks.ARMOR_DISPLAY);
        ModCreativeGroups.ezPop(p, ModBlocks.TICKET_KIOSK);
        ModCreativeGroups.ezPop(p, ModBlocks.BOOKSHELF_TRADER, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.SLOT_MACHINE);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_NETWORK_TRADER_1);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_NETWORK_TRADER_2);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_NETWORK_TRADER_3);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_NETWORK_TRADER_4);
        ModCreativeGroups.ezPop(p, ModBlocks.PAYGATE);
    }).m_257652_());
    public static final RegistryObject<CreativeModeTab> UPGRADE_GROUP = ModRegistries.CREATIVE_TABS.register("upgrades", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{TRADER_GROUP_ID}).m_257941_((Component)EasyText.translatable("itemGroup.lightmanscurrency.upgrades", new Object[0])).m_257737_(ModCreativeGroups.ezIcon(ModItems.ITEM_CAPACITY_UPGRADE_1)).m_257501_((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModItems.UPGRADE_SMITHING_TEMPLATE);
        ModCreativeGroups.ezPop(p, ModItems.ITEM_CAPACITY_UPGRADE_1);
        ModCreativeGroups.ezPop(p, ModItems.ITEM_CAPACITY_UPGRADE_2);
        ModCreativeGroups.ezPop(p, ModItems.ITEM_CAPACITY_UPGRADE_3);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_1);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_2);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_3);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_4);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_5);
        ModCreativeGroups.ezPop(p, ModItems.NETWORK_UPGRADE);
        ModCreativeGroups.ezPop(p, ModItems.HOPPER_UPGRADE);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_EXCHANGE_UPGRADE);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_MAGNET_UPGRADE_1);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_MAGNET_UPGRADE_2);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_MAGNET_UPGRADE_3);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_MAGNET_UPGRADE_4);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_SECURITY_UPGRADE);
    }).m_257652_());
    @Nullable
    public static RegistryObject<CreativeModeTab> EXTRA_GROUP = WoodType.hasModdedValues() ? ModRegistries.CREATIVE_TABS.register("extra", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{TRADER_GROUP_ID}).withTabsAfter(new ResourceLocation[]{UPGRADE_GROUP_ID}).m_257941_((Component)EasyText.translatable("itemGroup.lightmanscurrency.extra", new Object[0])).m_257737_(ModCreativeGroups.ezRandomIcon(ModCreativeGroups::getExtraGroup)).m_257501_((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModBlocks.AUCTION_STAND, BundleRequestFilter.MODDED);
        ModCreativeGroups.ezPop(p, ModBlocks.SHELF, BundleRequestFilter.MODDED);
        ModCreativeGroups.ezPop(p, ModBlocks.CARD_DISPLAY, BundleRequestFilter.MODDED);
        ModCreativeGroups.ezPop(p, ModBlocks.BOOKSHELF_TRADER, BundleRequestFilter.MODDED);
    }).m_257652_()) : null;

    public static void init() {
    }

    private static CreativeModeTab getExtraGroup() {
        return (CreativeModeTab)EXTRA_GROUP.get();
    }

    @SubscribeEvent
    public static void buildVanillaTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.accept(ModBlocks.PIGGY_BANK);
            event.accept(ModBlocks.COINJAR_BLUE);
        }
        if (event.getTabKey() == CreativeModeTabs.f_257028_) {
            event.accept(ModBlocks.PAYGATE);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256725_) {
            event.m_246601_(ModCreativeGroups.convertToStack(ModBlocks.VENDING_MACHINE.getAllSorted()));
            event.m_246601_(ModCreativeGroups.convertToStack(ModBlocks.VENDING_MACHINE_LARGE.getAllSorted()));
            event.m_246601_(ModCreativeGroups.convertToStack(ModBlocks.FREEZER.getAllSorted()));
            Color[] colorArray = ((Block)ModBlocks.SUS_JAR.get()).m_5456_();
            if (colorArray instanceof DyeableLeatherItem) {
                DyeableLeatherItem susItem = (DyeableLeatherItem)colorArray;
                for (Color c : Color.values()) {
                    ItemStack stack = new ItemStack((ItemLike)ModBlocks.SUS_JAR.get());
                    if (c != Color.WHITE) {
                        susItem.m_41115_(stack, c.hexColor);
                    }
                    event.m_246342_(stack);
                }
            }
        }
    }

    private static Supplier<ItemStack> ezIcon(RegistryObject<? extends ItemLike> item) {
        return Suppliers.memoize(() -> new ItemStack((ItemLike)item.get()));
    }

    private static Supplier<ItemStack> ezRandomIcon(Supplier<CreativeModeTab> tabSource) {
        return () -> {
            CreativeModeTab tab = (CreativeModeTab)tabSource.get();
            List items = tab.m_260957_().stream().toList();
            return (ItemStack)items.get((int)(TimeUtil.getCurrentTime() / 1000L % (long)items.size()));
        };
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObject<? extends ItemLike> item) {
        populator.m_246326_((ItemLike)item.get());
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObjectBundle<? extends ItemLike, ?> bundle) {
        bundle.getAllSorted().forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObjectBundle<? extends ItemLike, ?> bundle, BundleRequestFilter filter) {
        bundle.getAllSorted(filter).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObjectBiBundle<? extends ItemLike, ?, ?> bundle) {
        bundle.getAllSorted().forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObjectBiBundle<? extends ItemLike, ?, ?> bundle, BundleRequestFilter filter) {
        bundle.getAllSorted(filter).forEach(arg_0 -> ((CreativeModeTab.Output)populator).m_246326_(arg_0));
    }

    private static Collection<ItemStack> convertToStack(Collection<? extends ItemLike> list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemLike itemLike : list) {
            result.add(new ItemStack(itemLike));
        }
        return result;
    }
}

