/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.mixins;

import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tallestred.piglinproliferation.common.items.BucklerItem;
import tallestred.piglinproliferation.common.items.PPItems;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin<T extends LivingEntity>
extends AgeableListModel<T> {
    @Shadow
    @Final
    public ModelPart f_102812_;
    @Shadow
    @Final
    public ModelPart f_102811_;

    @Inject(at={@At(value="TAIL")}, method={"setupAnim"})
    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            this.bucklerAnimationsRightArm(InteractionHand.MAIN_HAND, entityIn);
            this.bucklerAnimationsLeftArm(InteractionHand.OFF_HAND, entityIn);
        } else {
            this.bucklerAnimationsLeftArm(InteractionHand.MAIN_HAND, entityIn);
            this.bucklerAnimationsRightArm(InteractionHand.OFF_HAND, entityIn);
        }
    }

    public void bucklerAnimationsLeftArm(InteractionHand hand, T entityIn) {
        if (entityIn.m_7655_() == hand && entityIn.m_21120_(entityIn.m_7655_()).m_41720_() instanceof BucklerItem) {
            float useDuration = entityIn.m_21120_(entityIn.m_7655_()).m_41779_();
            float useDurationClamped = Mth.m_14036_((float)entityIn.m_21252_(), (float)0.0f, (float)useDuration);
            float result = useDurationClamped / useDuration;
            this.f_102812_.f_104204_ = Mth.m_14179_((float)result, (float)this.f_102812_.f_104204_, (float)1.1466813f);
            this.f_102812_.f_104203_ = Mth.m_14179_((float)result, (float)this.f_102812_.f_104203_, (float)(this.f_102812_.f_104203_ * 0.1f - 1.5f));
        }
        if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(entityIn)) > 0 && BucklerItem.isReady(entityIn.m_21120_(hand))) {
            ItemStack handItems;
            ItemStack itemStack = handItems = hand == InteractionHand.MAIN_HAND ? entityIn.m_21206_() : entityIn.m_21205_();
            if (!handItems.m_41619_()) {
                this.f_102811_.f_104203_ = -2.0132742f;
                this.f_102811_.f_104204_ = 0.5235988f;
            }
            this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.1f - 1.5f;
            this.f_102812_.f_104204_ = 1.1466813f;
        }
    }

    public void bucklerAnimationsRightArm(InteractionHand hand, T entityIn) {
        if (entityIn.m_7655_() == hand && entityIn.m_21120_(entityIn.m_7655_()).m_41720_() instanceof BucklerItem) {
            float useDuration = entityIn.m_21120_(entityIn.m_7655_()).m_41779_();
            float useDurationClamped = Mth.m_14036_((float)entityIn.m_21252_(), (float)0.0f, (float)useDuration);
            float result = useDurationClamped / useDuration;
            this.f_102811_.f_104204_ = Mth.m_14179_((float)result, (float)this.f_102811_.f_104204_, (float)-1.1466813f);
            this.f_102811_.f_104203_ = Mth.m_14179_((float)result, (float)this.f_102811_.f_104203_, (float)(this.f_102811_.f_104203_ * 0.1f - 1.5f));
        }
        if (BucklerItem.getChargeTicks(PPItems.checkEachHandForBuckler(entityIn)) > 0 && BucklerItem.isReady(entityIn.m_21120_(hand))) {
            ItemStack handItems;
            ItemStack itemStack = handItems = hand == InteractionHand.MAIN_HAND ? entityIn.m_21206_() : entityIn.m_21205_();
            if (!handItems.m_41619_()) {
                this.f_102812_.f_104203_ = -2.0132742f;
                this.f_102812_.f_104204_ = -0.5235988f;
            }
            this.f_102811_.f_104203_ = -1.5f;
            this.f_102811_.f_104204_ = -1.1466813f;
        }
    }
}

